/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.register.datapack;

import com.mojang.serialization.Codec;
import dev.amble.lib.AmbleKit;
import dev.amble.lib.api.Identifiable;
import dev.amble.lib.register.datapack.DatapackRegistry;
import dev.amble.lib.util.ServerLifecycleHooks;
import java.io.InputStream;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public abstract class SimpleDatapackRegistry<T extends Identifiable>
extends DatapackRegistry<T>
implements SimpleSynchronousResourceReloadListener {
    private final Function<InputStream, T> deserializer;
    private final Codec<T> codec;
    protected final ResourceLocation packet;
    private final ResourceLocation name;
    private final boolean sync;

    public SimpleDatapackRegistry(Function<InputStream, T> deserializer, Codec<T> codec, ResourceLocation packet, ResourceLocation name, boolean sync) {
        this.deserializer = deserializer;
        this.codec = codec;
        this.packet = packet;
        this.name = name;
        this.sync = sync;
    }

    protected SimpleDatapackRegistry(Function<InputStream, T> deserializer, Codec<T> codec, String packet, String name, boolean sync, String modid) {
        this(deserializer, codec, new ResourceLocation(modid, "sync_" + packet), new ResourceLocation(modid, name), sync);
    }

    protected SimpleDatapackRegistry(Function<InputStream, T> deserializer, Codec<T> codec, String name, boolean sync, String modid) {
        this(deserializer, codec, name, name, sync, modid);
    }

    @Deprecated(forRemoval=true, since="1.0.11")
    protected SimpleDatapackRegistry(Function<InputStream, T> deserializer, Codec<T> codec, String name) {
        this(deserializer, codec, name, name, true, "amblekit");
    }

    @Override
    public void onClientInit() {
        if (!this.sync) {
            return;
        }
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)this.packet, (client, handler, buf, responseSender) -> this.readFromServer(buf));
    }

    @Override
    public void onServerInit() {
    }

    @Override
    public void onCommonInit() {
        ResourceManagerHelper.get((PackType)PackType.SERVER_DATA).registerReloadListener((IdentifiableResourceReloadListener)this);
        if (!this.sync) {
            return;
        }
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> this.syncToClient(player));
    }

    @Override
    public void syncToEveryone() {
        if (!this.sync || ServerLifecycleHooks.get() == null) {
            return;
        }
        super.syncToEveryone();
    }

    @Override
    public void syncToClient(ServerPlayer player) {
        if (!this.sync) {
            return;
        }
        FriendlyByteBuf buf = PacketByteBufs.create();
        buf.writeInt(this.REGISTRY.size());
        for (Identifiable schema : this.REGISTRY.values()) {
            buf.m_272073_(this.codec, (Object)schema);
        }
        ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)this.packet, (FriendlyByteBuf)buf);
    }

    @Override
    public void readFromServer(FriendlyByteBuf buf) {
        if (!this.sync) {
            return;
        }
        this.defaults();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.register((Identifiable)buf.m_271872_(this.codec));
        }
        AmbleKit.LOGGER.info("Read {} {} from server", (Object)size, (Object)this.name);
    }

    protected abstract void defaults();

    protected T read(InputStream stream) {
        return (T)((Identifiable)this.deserializer.apply(stream));
    }

    public ResourceLocation getFabricId() {
        return this.name;
    }

    public void m_6213_(ResourceManager manager) {
        this.defaults();
        for (ResourceLocation id : manager.m_214159_(this.name.m_135815_(), filename -> filename.m_135815_().endsWith(".json")).keySet()) {
            try {
                InputStream stream = ((Resource)manager.m_213713_(id).get()).m_215507_();
                try {
                    T created = this.read(stream);
                    if (created == null) {
                        stream.close();
                        continue;
                    }
                    this.register(created);
                    AmbleKit.LOGGER.info("Loaded datapack {} {}", (Object)this.name, (Object)created.id().toString());
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                AmbleKit.LOGGER.error("Error occurred while loading resource json {}", (Object)id.toString(), (Object)e);
            }
        }
        this.syncToEveryone();
    }
}

