/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.register.datapack;

import dev.amble.lib.AmbleKit;
import dev.amble.lib.api.Identifiable;
import dev.amble.lib.register.Registry;
import dev.amble.lib.util.ServerLifecycleHooks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public abstract class DatapackRegistry<T extends Identifiable>
implements Registry {
    protected static final Random RANDOM = new Random();
    protected final HashMap<ResourceLocation, T> REGISTRY = new HashMap();

    public abstract T fallback();

    public T register(T schema) {
        return this.register(schema, schema.id());
    }

    public T register(T schema, ResourceLocation id) {
        this.REGISTRY.put(id, schema);
        return schema;
    }

    protected static <T> T getRandom(List<T> elements, Random random, Supplier<T> fallback) {
        if (elements.isEmpty()) {
            return fallback.get();
        }
        int randomized = random.nextInt(elements.size());
        return elements.get(randomized);
    }

    public T getRandom(Random random) {
        return (T)DatapackRegistry.getRandom(this.toList(), random, this::fallback);
    }

    public T getRandom() {
        return this.getRandom(RANDOM);
    }

    public List<T> getRandom(int count) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < count; ++i) {
            list.add(this.getRandom());
        }
        return list;
    }

    public T get(ResourceLocation id) {
        return (T)((Identifiable)this.REGISTRY.get(id));
    }

    public T getOrElse(ResourceLocation id, T fallback) {
        return (T)((Identifiable)this.REGISTRY.getOrDefault(id, fallback));
    }

    public T getOrFallback(ResourceLocation id) {
        return this.getOrElse(id, this.fallback());
    }

    public Optional<T> getOptional(ResourceLocation id) {
        return Optional.ofNullable(this.get(id));
    }

    public List<T> toList() {
        return List.copyOf(this.REGISTRY.values());
    }

    public Iterator<T> iterator() {
        return this.REGISTRY.values().iterator();
    }

    public int size() {
        return this.REGISTRY.size();
    }

    public void syncToEveryone() {
        if (ServerLifecycleHooks.get() == null) {
            AmbleKit.LOGGER.warn("ServerLifecycleHooks is null, cannot sync");
            return;
        }
        for (ServerPlayer player : ServerLifecycleHooks.get().m_6846_().m_11314_()) {
            this.syncToClient(player);
        }
    }

    public abstract void syncToClient(ServerPlayer var1);

    public abstract void readFromServer(FriendlyByteBuf var1);

    @Override
    public void onCommonInit() {
    }

    public void clearCache() {
        this.REGISTRY.clear();
    }
}

