/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.itemgroup;

import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;

public class AItemGroup
extends CreativeModeTab {
    private final ResourceLocation id;

    protected AItemGroup(ResourceLocation id, CreativeModeTab.Builder builder) {
        super(builder);
        this.id = id;
    }

    public ResourceLocation id() {
        return this.id;
    }

    public static Builder builder(ResourceLocation id) {
        return new Builder(id);
    }

    public static class Builder {
        private static final CreativeModeTab.DisplayItemsGenerator EMPTY_ENTRIES = (displayContext, entries) -> {};
        private Component displayName = null;
        private Supplier<ItemStack> iconSupplier = () -> ItemStack.f_41583_;
        private CreativeModeTab.DisplayItemsGenerator entryCollector = EMPTY_ENTRIES;
        private boolean scrollbar = true;
        private boolean renderName = true;
        private boolean special = false;
        private CreativeModeTab.Type type = CreativeModeTab.Type.CATEGORY;
        private String texture = "items.png";
        private final ResourceLocation id;

        public Builder(ResourceLocation id) {
            this.id = id;
        }

        public Builder displayName(Component displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder icon(Supplier<ItemStack> iconSupplier) {
            this.iconSupplier = iconSupplier;
            return this;
        }

        public Builder entries(CreativeModeTab.DisplayItemsGenerator entryCollector) {
            this.entryCollector = entryCollector;
            return this;
        }

        public Builder special() {
            this.special = true;
            return this;
        }

        public Builder noRenderedName() {
            this.renderName = false;
            return this;
        }

        public Builder noScrollbar() {
            this.scrollbar = false;
            return this;
        }

        protected Builder type(CreativeModeTab.Type type) {
            this.type = type;
            return this;
        }

        public Builder texture(String texture) {
            this.texture = texture;
            return this;
        }

        public AItemGroup build() {
            if ((this.type == CreativeModeTab.Type.HOTBAR || this.type == CreativeModeTab.Type.INVENTORY) && this.entryCollector != EMPTY_ENTRIES) {
                throw new IllegalStateException("Special tabs can't have display items");
            }
            if (this.displayName == null) {
                this.displayName = Component.m_237115_((String)("itemGroup." + this.id.m_135827_() + "." + this.id.m_135815_()));
            }
            CreativeModeTab.Builder builder = new CreativeModeTab.Builder(null, -1);
            if (this.special) {
                builder = builder.m_257826_();
            }
            if (!this.renderName) {
                builder = builder.m_257809_();
            }
            if (!this.scrollbar) {
                builder = builder.m_257794_();
            }
            builder = builder.m_257609_(this.texture).m_257941_(this.displayName).m_257737_(this.iconSupplier).m_257501_(this.entryCollector).withTabFactory(b -> new AItemGroup(this.id, (CreativeModeTab.Builder)b));
            return (AItemGroup)builder.m_257652_();
        }
    }
}

