/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.datagen.tag;

import dev.amble.lib.container.impl.BlockContainer;
import dev.amble.lib.datagen.util.PickaxeMineable;
import dev.amble.lib.util.ReflectionUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;

public class AmbleBlockTagProvider
extends FabricTagProvider.BlockTagProvider {
    protected Queue<Class<? extends BlockContainer>> blockClass = new LinkedList<Class<? extends BlockContainer>>();

    public AmbleBlockTagProvider(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
        super(output, registriesFuture);
    }

    protected void m_6577_(HolderLookup.Provider wrapperLookup) {
        this.blockClass.forEach(clazz -> {
            FabricTagProvider.FabricTagBuilder pickaxeBuilder = this.getOrCreateTagBuilder(BlockTags.f_144282_);
            HashMap<Block, Optional<PickaxeMineable>> pickaxeBlocks = ReflectionUtil.getAnnotatedValues(clazz, Block.class, PickaxeMineable.class, false);
            for (Block block : pickaxeBlocks.keySet()) {
                pickaxeBuilder.add((Object)block);
                PickaxeMineable annotation = pickaxeBlocks.get(block).orElseThrow();
                if (annotation.tool() == PickaxeMineable.Tool.NONE) continue;
                this.getOrCreateTagBuilder(annotation.tool().tag).add((Object)block);
            }
        });
    }

    public AmbleBlockTagProvider withBlocks(Class<? extends BlockContainer> ... blockClass) {
        this.blockClass.addAll(Arrays.asList(blockClass));
        return this;
    }
}

