/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.datagen.sound;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.amble.lib.AmbleKit;
import dev.amble.lib.util.StringCursor;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.Nullable;

public class AmbleSoundProvider
implements DataProvider {
    protected final FabricDataOutput dataOutput;
    private final Map<String, Set<SoundEventWrapper>> sounds = new HashMap<String, Set<SoundEventWrapper>>();
    private final boolean extractVariants;

    public AmbleSoundProvider(FabricDataOutput dataOutput) {
        this(dataOutput, true);
    }

    public AmbleSoundProvider(FabricDataOutput dataOutput, boolean extractVariants) {
        this.dataOutput = dataOutput;
        this.extractVariants = extractVariants;
    }

    private boolean canAdd(String name, boolean check) {
        return check && !AmbleSoundProvider.checkName(name);
    }

    public void addSound(String name, SoundEvent event) {
        this.addSound(name, true, event);
    }

    public void addSound(String name, boolean check, SoundEvent event) {
        if (this.canAdd(name, check)) {
            return;
        }
        this.sounds.computeIfAbsent(name, s -> new HashSet()).add(new SoundEventWrapper(event));
    }

    public void addSound(String name, SoundEvent ... events) {
        this.addSound(name, true, events);
    }

    public void addSound(String name, boolean check, SoundEvent ... events) {
        if (this.canAdd(name, check)) {
            return;
        }
        Set set = this.sounds.computeIfAbsent(name, s -> new HashSet());
        for (SoundEvent event : events) {
            set.add(new SoundEventWrapper(event));
        }
    }

    public CompletableFuture<?> m_213708_(CachedOutput writer) {
        AmbleSoundProvider.getSoundsFromMod(this.dataOutput.getModId()).forEach(sound -> {
            String path = sound.m_11660_().m_135815_();
            this.addSound(path, false, (SoundEvent)sound);
            if (this.extractVariants) {
                String newPath = AmbleSoundProvider.extractPath(path);
                if (newPath == null) {
                    return;
                }
                this.addSound(newPath, false, (SoundEvent)sound);
            }
        });
        JsonObject soundsJson = new JsonObject();
        this.sounds.forEach((soundName, soundEvents) -> soundsJson.add(soundName, (JsonElement)AmbleSoundProvider.serializeSounds(soundEvents)));
        return DataProvider.m_253162_((CachedOutput)writer, (JsonElement)soundsJson, (Path)this.getOutputPath());
    }

    public Path getOutputPath() {
        return this.dataOutput.m_247566_(PackOutput.Target.RESOURCE_PACK).resolve(this.dataOutput.getModId()).resolve("sounds.json");
    }

    public String m_6055_() {
        return "Sound Definitions";
    }

    private static JsonObject serializeSounds(Iterable<SoundEventWrapper> wrappers) {
        JsonObject obj = new JsonObject();
        JsonArray sounds = new JsonArray();
        for (SoundEventWrapper wrapper : wrappers) {
            sounds.add(wrapper.event.m_11660_().toString());
        }
        obj.add("sounds", (JsonElement)sounds);
        return obj;
    }

    @Nullable
    private static String extractPath(String path) {
        StringCursor cursor = new StringCursor(path, path.length() - 1, -1);
        while (Character.isDigit(cursor.peek())) {
            cursor.next();
        }
        return cursor.substring();
    }

    private static boolean checkName(String name) {
        if (name.contains(" ")) {
            AmbleKit.LOGGER.error("Sound event name cannot contain spaces: {}", (Object)name);
            return false;
        }
        char[] cArray = name.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character character = Character.valueOf(cArray[i]);
            if (!Character.isUpperCase(character.charValue())) continue;
            AmbleKit.LOGGER.error("Sound event name cannot contain capital letters: {}", (Object)name);
            return false;
        }
        return true;
    }

    public static Stream<SoundEvent> getSoundsFromMod(String namespace) {
        return BuiltInRegistries.f_256894_.m_123024_().filter(sound -> sound.m_11660_().m_135827_().equals(namespace));
    }

    static class SoundEventWrapper {
        private final SoundEvent event;

        public SoundEventWrapper(SoundEvent event) {
            this.event = event;
        }

        public int hashCode() {
            return this.event.m_11660_().hashCode();
        }
    }
}

