/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.datagen.model;

import dev.amble.lib.AmbleKit;
import dev.amble.lib.container.impl.BlockContainer;
import dev.amble.lib.container.impl.ItemContainer;
import dev.amble.lib.datagen.util.AutomaticModel;
import dev.amble.lib.mixin.client.ItemModelGeneratorAccessor;
import dev.amble.lib.util.ReflectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class AmbleModelProvider
extends FabricModelProvider {
    protected final String modid;
    protected final FabricDataOutput output;
    protected List<Class<? extends BlockContainer>> blockClass;
    protected Queue<Class<? extends ItemContainer>> itemClass;

    public AmbleModelProvider(FabricDataOutput output) {
        super(output);
        this.modid = output.getModId();
        this.output = output;
        this.blockClass = new ArrayList<Class<? extends BlockContainer>>();
        this.itemClass = new LinkedList<Class<? extends ItemContainer>>();
    }

    public void generateBlockStateModels(BlockModelGenerators generator) {
        this.blockClass.forEach(clazz -> ReflectionUtil.getAnnotatedValues(clazz, Block.class, AutomaticModel.class, false).forEach((block, annotation) -> {
            if (!((AutomaticModel)annotation.orElseThrow()).justItem()) {
                generator.m_124851_(block);
            }
        }));
    }

    public void generateItemModels(ItemModelGenerators generator) {
        this.blockClass.forEach(clazz -> ReflectionUtil.getAnnotatedValues(clazz, Block.class, AutomaticModel.class, false).forEach((block, annotation) -> {
            if (((AutomaticModel)annotation.orElseThrow()).justItem()) {
                this.registerItem(generator, block.m_5456_(), this.modid);
            }
        }));
        this.itemClass.forEach(clazz -> ReflectionUtil.getAnnotatedValues(clazz, Item.class, AutomaticModel.class, false).forEach((item, annotation) -> this.registerItem(generator, (Item)item, this.modid)));
    }

    public AmbleModelProvider withBlocks(Class<? extends BlockContainer> ... blockClass) {
        this.blockClass.addAll(Arrays.asList(blockClass));
        return this;
    }

    public AmbleModelProvider withItems(Class<? extends ItemContainer> ... itemClass) {
        this.itemClass.addAll(Arrays.asList(itemClass));
        return this;
    }

    private static ModelTemplate item(String modid, String parent, TextureSlot ... requiredTextureKeys) {
        return new ModelTemplate(Optional.of(new ResourceLocation(modid, "item/" + parent)), Optional.empty(), requiredTextureKeys);
    }

    private static ModelTemplate item(TextureSlot ... requiredTextureKeys) {
        return AmbleModelProvider.item("minecraft", "generated", requiredTextureKeys);
    }

    private void registerItem(ItemModelGenerators generator, Item item, String modid) {
        ModelTemplate model = AmbleModelProvider.item(TextureSlot.f_125863_);
        model.m_125612_(ModelLocationUtils.m_125571_((Item)item), this.createTextureMap(item, modid), ((ItemModelGeneratorAccessor)generator).getWriter());
    }

    private TextureMapping createTextureMap(Item item, String modid) {
        ResourceLocation texture = new ResourceLocation(modid, "item/" + AmbleModelProvider.getItemName(item));
        if (!this.doesTextureExist(texture)) {
            texture = AmbleKit.id("item/error");
        }
        return new TextureMapping().m_125758_(TextureSlot.f_125863_, texture);
    }

    private static String getItemName(Item item) {
        return item.m_5524_().split("\\.")[2];
    }

    public boolean doesTextureExist(ResourceLocation texture) {
        return this.output.getModContainer().findPath("assets/" + texture.m_135827_() + "/textures/" + texture.m_135815_() + ".png").isPresent();
    }
}

