/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.datagen.loot;

import dev.amble.lib.container.impl.BlockContainer;
import dev.amble.lib.datagen.util.NoBlockDrop;
import dev.amble.lib.util.ReflectionUtil;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Queue;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.minecraft.world.level.block.Block;

public class AmbleBlockLootTable
extends FabricBlockLootTableProvider {
    protected Queue<Class<? extends BlockContainer>> blockClass = new LinkedList<Class<? extends BlockContainer>>();

    public AmbleBlockLootTable(FabricDataOutput dataOutput) {
        super(dataOutput);
    }

    public void m_245660_() {
        this.blockClass.forEach(clazz -> ReflectionUtil.getAnnotatedValues(clazz, Block.class, NoBlockDrop.class, true).forEach(this::process));
    }

    @SafeVarargs
    public final AmbleBlockLootTable withBlocks(Class<? extends BlockContainer> ... blockClass) {
        this.blockClass.addAll(Arrays.asList(blockClass));
        return this;
    }

    protected void process(Block block, Optional<NoBlockDrop> annotation) {
        this.m_245724_(block);
        NoBlockDrop drop = annotation.orElse(null);
        if (drop != null) {
            if (drop.requireSilkTouch()) {
                this.m_245644_(block);
            }
            if (drop.slabDrops()) {
                this.m_247233_(block);
            }
        }
    }
}

