/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.datagen.lang;

import dev.amble.lib.container.RegistryContainer;
import dev.amble.lib.container.impl.BlockContainer;
import dev.amble.lib.container.impl.ItemContainer;
import dev.amble.lib.datagen.lang.LanguageType;
import dev.amble.lib.datagen.util.NoEnglish;
import dev.amble.lib.util.ReflectionUtil;
import java.util.HashMap;
import java.util.Set;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class AmbleLanguageProvider
extends FabricLanguageProvider {
    private final FabricDataOutput output;
    protected final String modid;
    protected HashMap<String, String> translations = new HashMap();
    public LanguageType language;

    public AmbleLanguageProvider(FabricDataOutput output, LanguageType language) {
        super(output, language.name().toLowerCase());
        this.output = output;
        this.language = language;
        this.modid = output.getModId();
    }

    public void generateTranslations(FabricLanguageProvider.TranslationBuilder builder) {
        for (String key : this.translations.keySet()) {
            builder.add(key, this.translations.get(key));
        }
        this.output.getModContainer().findPath("assets/" + this.modid + "/lang/" + this.language.name().toLowerCase() + ".existing.json").ifPresent(existingFilePath -> {
            try {
                builder.add(existingFilePath);
            }
            catch (Exception e) {
                f_252483_.warn("Failed to add existing language file! ({}) | ", (Object)this.language.name().toLowerCase(), (Object)e);
            }
        });
    }

    public void addTranslation(Item item, String translation) {
        this.translations.put(item.m_5524_(), translation);
    }

    public void addTranslation(CreativeModeTab itemGroup, String translation) {
        ComponentContents componentContents = itemGroup.m_40786_().m_214077_();
        if (!(componentContents instanceof TranslatableContents)) {
            return;
        }
        TranslatableContents translatable = (TranslatableContents)componentContents;
        this.translations.put(translatable.m_237508_(), translation);
    }

    public void addTranslation(String key, String translation) {
        this.translations.put(key, translation);
    }

    public void addTranslation(Block block, String translation) {
        this.translations.put(block.m_7705_(), translation);
    }

    public <T, R extends RegistryContainer<T>> void addTranslation(Class<R> containerClazz, Class<T> valueClazz, Translator<T> translator) {
        Set<T> values = ReflectionUtil.getAnnotatedValues(containerClazz, valueClazz, NoEnglish.class, true).keySet();
        for (T value : values) {
            translator.addTranslation(this, value);
        }
    }

    public void translateItems(Class<? extends ItemContainer> container) {
        this.addTranslation(container, Item.class, (provider, value) -> {
            if (value instanceof BlockItem) {
                return;
            }
            provider.addTranslation((Item)value, AmbleLanguageProvider.getNameFromKey(value.m_5524_()));
        });
    }

    public void translateBlocks(Class<? extends BlockContainer> container) {
        this.addTranslation(container, Block.class, (provider, value) -> provider.addTranslation((Block)value, AmbleLanguageProvider.getNameFromKey(value.m_7705_())));
    }

    public static String getNameFromKey(String key) {
        int lastDot = key.lastIndexOf(46);
        if (lastDot == -1) {
            return key;
        }
        String suffix = key.substring(lastDot + 1);
        String[] parts = suffix.split("_");
        StringBuilder builder = new StringBuilder();
        for (String part : parts) {
            builder.append(part.substring(0, 1).toUpperCase());
            builder.append(part.substring(1));
            builder.append(" ");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    @FunctionalInterface
    public static interface Translator<T> {
        public void addTranslation(AmbleLanguageProvider var1, T var2);
    }
}

