/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.amble.lib.data.DirectedBlockPos;
import dev.amble.lib.data.DistanceInformation;
import java.lang.reflect.Type;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.RotationSegment;

public class DirectedGlobalPos {
    public static final Codec<DirectedGlobalPos> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Level.f_46427_.fieldOf("dimension").forGetter(DirectedGlobalPos::getDimension), (App)BlockPos.f_121852_.fieldOf("pos").forGetter(DirectedGlobalPos::getPos), (App)Codec.BYTE.fieldOf("rotation").forGetter(DirectedGlobalPos::getRotation)).apply((Applicative)instance, DirectedGlobalPos::create));
    private final ResourceKey<Level> dimension;
    private final BlockPos pos;
    private final byte rotation;

    protected DirectedGlobalPos(ResourceKey<Level> dimension, BlockPos pos, byte rotation) {
        this.dimension = dimension;
        this.pos = pos;
        this.rotation = rotation;
    }

    public DirectedGlobalPos pos(int x, int y, int z) {
        return this.pos(new BlockPos(x, y, z));
    }

    public DirectedGlobalPos pos(BlockPos pos) {
        return DirectedGlobalPos.create(this.dimension, pos, this.rotation);
    }

    public DirectedGlobalPos offset(int x, int y, int z) {
        return DirectedGlobalPos.create(this.dimension, this.pos.m_7918_(x, y, z), this.rotation);
    }

    public DirectedGlobalPos offset(Direction dir) {
        return DirectedGlobalPos.create(this.dimension, this.pos.m_121945_(dir), this.rotation);
    }

    public DirectedGlobalPos rotation(byte rotation) {
        return DirectedGlobalPos.create(this.dimension, this.pos, rotation);
    }

    public DirectedGlobalPos world(ResourceKey<Level> world) {
        return DirectedGlobalPos.create(world, this.pos, this.rotation);
    }

    public static DirectedGlobalPos create(ResourceKey<Level> dimension, BlockPos pos, byte rotation) {
        return new DirectedGlobalPos(dimension, pos, rotation);
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public byte getRotation() {
        return this.rotation;
    }

    public float getRotationDegrees() {
        return RotationSegment.m_245107_((int)this.getRotation());
    }

    public Direction getRotationDirection() {
        return Direction.m_122364_((double)this.getRotationDegrees());
    }

    public Vec3i getVector() {
        return switch (this.rotation) {
            case 0 -> Direction.NORTH.m_122436_();
            case 1, 2, 3 -> Direction.NORTH.m_122436_().m_121955_(Direction.EAST.m_122436_());
            case 4 -> Direction.EAST.m_122436_();
            case 5, 6, 7 -> Direction.EAST.m_122436_().m_121955_(Direction.SOUTH.m_122436_());
            case 8 -> Direction.SOUTH.m_122436_();
            case 9, 10, 11 -> Direction.SOUTH.m_122436_().m_121955_(Direction.WEST.m_122436_());
            case 12 -> Direction.WEST.m_122436_();
            case 13, 14, 15 -> Direction.NORTH.m_122436_().m_121955_(Direction.SOUTH.m_122436_());
            default -> new Vec3i(0, 0, 0);
        };
    }

    public DistanceInformation distanceTo(DirectedGlobalPos other) {
        double distance = Math.sqrt(this.pos.m_123331_((Vec3i)other.pos));
        boolean dimChange = !this.dimension.equals(other.dimension);
        boolean rotChange = this.rotation != other.rotation;
        return new DistanceInformation(distance, dimChange, rotChange);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DirectedGlobalPos)) {
            return false;
        }
        DirectedGlobalPos globalPos = (DirectedGlobalPos)o;
        return Objects.equals(this.dimension, globalPos.dimension) && Objects.equals(this.pos, globalPos.pos) && Objects.equals(this.rotation, globalPos.rotation);
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.pos, this.rotation);
    }

    public String toString() {
        return this.dimension + " " + this.pos + " " + this.rotation;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_236858_(this.dimension);
        buf.m_130064_(this.pos);
        buf.writeByte((int)this.rotation);
    }

    public static DirectedGlobalPos read(FriendlyByteBuf buf) {
        ResourceKey registryKey = buf.m_236801_(Registries.f_256858_);
        BlockPos blockPos = buf.m_130135_();
        byte rotation = buf.readByte();
        return DirectedGlobalPos.create((ResourceKey<Level>)registryKey, blockPos, rotation);
    }

    public CompoundTag toNbt() {
        CompoundTag compound = NbtUtils.m_129224_((BlockPos)this.pos);
        compound.m_128359_("dimension", this.dimension.m_135782_().toString());
        compound.m_128344_("rotation", this.rotation);
        return compound;
    }

    public static DirectedGlobalPos fromNbt(CompoundTag compound) {
        BlockPos pos = NbtUtils.m_129239_((CompoundTag)compound);
        ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(compound.m_128461_("dimension")));
        byte rotation = compound.m_128445_("rotation");
        return DirectedGlobalPos.create((ResourceKey<Level>)dimension, pos, rotation);
    }

    public DirectedBlockPos toPos() {
        return DirectedBlockPos.create(this.pos, this.rotation);
    }

    public static int getNextGeneralizedRotation(int rotation) {
        return (rotation + 2) % 16;
    }

    public static int getPreviousGeneralizedRotation(int rotation) {
        return (rotation - 2) % 16;
    }

    public static byte getGeneralizedRotation(int rotation) {
        if (rotation % 2 != 0 && rotation < 15) {
            return (byte)(rotation + 1);
        }
        if (rotation == 15) {
            return 0;
        }
        return (byte)rotation;
    }

    public static byte getGeneralizedRotation(Direction dir) {
        return DirectedGlobalPos.getGeneralizedRotation(RotationSegment.m_245225_((Direction)dir));
    }

    public static String rotationForArrow(int currentRot) {
        return switch (currentRot) {
            case 1, 2, 3 -> "\u2197";
            case 4 -> "\u2192";
            case 5, 6, 7 -> "\u2198";
            case 8 -> "\u2193";
            case 9, 10, 11 -> "\u2199";
            case 12 -> "\u2190";
            case 13, 14, 15 -> "\u2196";
            default -> "\u2191";
        };
    }

    public static byte wrap(byte value, byte max) {
        return (byte)((value % max + max) % max);
    }

    public static Object serializer() {
        return new Serializer();
    }

    private static class Serializer
    implements JsonDeserializer<DirectedGlobalPos>,
    JsonSerializer<DirectedGlobalPos> {
        private Serializer() {
        }

        public DirectedGlobalPos deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            ResourceKey dimension = (ResourceKey)context.deserialize(obj.get("dimension"), ResourceKey.class);
            int x = obj.get("x").getAsInt();
            int y = obj.get("y").getAsInt();
            int z = obj.get("z").getAsInt();
            byte rotation = obj.get("rotation").getAsByte();
            return DirectedGlobalPos.create((ResourceKey<Level>)dimension, new BlockPos(x, y, z), rotation);
        }

        public JsonElement serialize(DirectedGlobalPos src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject result = new JsonObject();
            result.addProperty("dimension", src.getDimension().m_135782_().toString());
            result.addProperty("x", (Number)src.getPos().m_123341_());
            result.addProperty("y", (Number)src.getPos().m_123342_());
            result.addProperty("z", (Number)src.getPos().m_123343_());
            result.addProperty("rotation", (Number)src.getRotation());
            return result;
        }
    }
}

