/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.amble.lib.data.DistanceInformation;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;

public class DirectedBlockPos {
    public static final Codec<DirectedBlockPos> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.f_121852_.fieldOf("pos").forGetter(DirectedBlockPos::getPos), (App)Codec.BYTE.fieldOf("rotation").forGetter(DirectedBlockPos::getRotation)).apply((Applicative)instance, DirectedBlockPos::create));
    private final BlockPos pos;
    private final byte rotation;

    private DirectedBlockPos(BlockPos pos, byte rotation) {
        this.pos = pos;
        this.rotation = rotation;
    }

    public DirectedBlockPos pos(int x, int y, int z) {
        return this.pos(new BlockPos(x, y, z));
    }

    public DirectedBlockPos pos(BlockPos pos) {
        return DirectedBlockPos.create(pos, this.rotation);
    }

    public Vec3 offsetPos(float value) {
        BlockPos pos = this.getPos();
        return new Vec3((double)((float)pos.m_123341_() + value * (float)this.getVector().m_123341_()), (double)((float)pos.m_123342_() + value * (float)this.getVector().m_123342_()), (double)((float)pos.m_123343_() + value * (float)this.getVector().m_123343_()));
    }

    public DirectedBlockPos offset(int x, int y, int z) {
        return DirectedBlockPos.create(this.pos.m_7918_(x, y, z), this.rotation);
    }

    public DirectedBlockPos apply(Function<Integer, Integer> func) {
        return DirectedBlockPos.create(new BlockPos(func.apply(this.pos.m_123341_()).intValue(), func.apply(this.pos.m_123342_()).intValue(), func.apply(this.pos.m_123343_()).intValue()), this.rotation);
    }

    public static DirectedBlockPos create(BlockPos pos, byte rotation) {
        return new DirectedBlockPos(pos, rotation);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public byte getRotation() {
        return this.rotation;
    }

    public Vec3i getVector() {
        return switch (this.rotation) {
            default -> new Vec3i(0, 0, 0);
            case 0 -> Direction.NORTH.m_122436_();
            case 1, 2, 3 -> Direction.NORTH.m_122436_().m_121955_(Direction.EAST.m_122436_());
            case 4 -> Direction.EAST.m_122436_();
            case 5, 6, 7 -> Direction.EAST.m_122436_().m_121955_(Direction.SOUTH.m_122436_());
            case 8 -> Direction.SOUTH.m_122436_();
            case 9, 10, 11 -> Direction.SOUTH.m_122436_().m_121955_(Direction.WEST.m_122436_());
            case 12 -> Direction.WEST.m_122436_();
            case 13, 14, 15 -> Direction.NORTH.m_122436_().m_121955_(Direction.SOUTH.m_122436_());
        };
    }

    public Direction toMinecraftDirection() {
        return switch (this.rotation) {
            case 1, 2, 3, 4 -> Direction.EAST;
            case 5, 6, 7, 8 -> Direction.SOUTH;
            case 9, 10, 11, 12 -> Direction.WEST;
            default -> Direction.NORTH;
        };
    }

    public DistanceInformation distanceTo(DirectedBlockPos other) {
        double distance = Math.sqrt(this.pos.m_123331_((Vec3i)other.pos));
        boolean rotChange = this.rotation != other.rotation;
        return new DistanceInformation(distance, false, rotChange);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DirectedBlockPos)) {
            return false;
        }
        DirectedBlockPos blockPos = (DirectedBlockPos)o;
        return Objects.equals(this.pos, blockPos.pos) && Objects.equals(this.rotation, blockPos.rotation);
    }

    public int hashCode() {
        return Objects.hash(this.pos, this.rotation);
    }

    public String toString() {
        return this.pos + " " + this.rotation;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.getPos());
        buf.writeByte((int)this.rotation);
    }

    public static DirectedBlockPos read(FriendlyByteBuf buf) {
        BlockPos blockPos = buf.m_130135_();
        byte rotation = buf.readByte();
        return DirectedBlockPos.create(blockPos, rotation);
    }

    public static Object serializer() {
        return new Serializer();
    }

    private static class Serializer
    implements JsonDeserializer<DirectedBlockPos>,
    JsonSerializer<DirectedBlockPos> {
        private Serializer() {
        }

        public DirectedBlockPos deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            int x = obj.get("x").getAsInt();
            int y = obj.get("y").getAsInt();
            int z = obj.get("z").getAsInt();
            byte rotation = obj.get("rotation").getAsByte();
            return DirectedBlockPos.create(new BlockPos(x, y, z), rotation);
        }

        public JsonElement serialize(DirectedBlockPos src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject result = new JsonObject();
            result.addProperty("x", (Number)src.getPos().m_123341_());
            result.addProperty("y", (Number)src.getPos().m_123342_());
            result.addProperty("z", (Number)src.getPos().m_123343_());
            result.addProperty("rotation", (Number)src.getRotation());
            return result;
        }
    }
}

