/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.container.impl;

import dev.amble.lib.block.ABlockSettings;
import dev.amble.lib.container.RegistryContainer;
import dev.amble.lib.container.impl.NoBlockItem;
import dev.amble.lib.item.AItem;
import dev.amble.lib.mixin.AbstractBlockAccessor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.jetbrains.annotations.Nullable;

public abstract class BlockContainer
implements RegistryContainer<Block> {
    private List<Item> items;

    @Override
    public void start(int fields) {
        this.items = new ArrayList<Item>(fields);
    }

    @Override
    public Class<Block> getTargetClass() {
        return Block.class;
    }

    @Override
    public Registry<Block> getRegistry() {
        return BuiltInRegistries.f_256975_;
    }

    @Override
    public void postProcessField(ResourceLocation identifier, Block value, Field field) {
        if (field.isAnnotationPresent(NoBlockItem.class)) {
            return;
        }
        Item.Properties itemSettings = null;
        BlockBehaviour.Properties properties = ((AbstractBlockAccessor)value).getSettings();
        if (properties instanceof ABlockSettings) {
            ABlockSettings abs = (ABlockSettings)properties;
            itemSettings = abs.itemSettings();
        }
        BlockItem item = this.createBlockItem(value, itemSettings);
        Registry.m_122965_((Registry)BuiltInRegistries.f_257033_, (ResourceLocation)identifier, (Object)item);
        this.items.add((Item)item);
    }

    @Override
    public void finish() {
        ItemGroupEvents.MODIFY_ENTRIES_ALL.register((group, entries) -> {
            for (Item item : this.items) {
                if (((AItem)item).a$group() != group) continue;
                entries.m_246326_((ItemLike)item);
            }
        });
    }

    public BlockItem createBlockItem(Block block, @Nullable Item.Properties settings) {
        return new BlockItem(block, settings == null ? this.createBlockItemSettings(block) : settings);
    }

    public Item.Properties createBlockItemSettings(Block block) {
        return new Item.Properties();
    }
}

