/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.container;

import dev.amble.lib.AmbleKit;
import dev.amble.lib.container.AssignedName;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Locale;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;

public interface RegistryContainer<T> {
    public Class<T> getTargetClass();

    public Registry<T> getRegistry();

    default public void postProcessField(ResourceLocation identifier, T value, Field field) {
    }

    public static <T> void register(Class<? extends RegistryContainer<T>> clazz, String namespace) {
        try {
            RegistryContainer<Object> container = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Field[] fields = clazz.getDeclaredFields();
            container.start(fields.length);
            for (Field field : fields) {
                Object v;
                if (!Modifier.isStatic(field.getModifiers()) || !container.getTargetClass().isAssignableFrom(field.getType()) || (v = field.get(null)) == null) continue;
                String name = field.getName().toLowerCase(Locale.ROOT);
                if (field.isAnnotationPresent(AssignedName.class)) {
                    name = field.getAnnotation(AssignedName.class).value();
                }
                ResourceLocation id = new ResourceLocation(namespace, name);
                Registry.m_122965_(container.getRegistry(), (ResourceLocation)id, (Object)v);
                container.postProcessField(id, v, field);
            }
            container.finish();
        }
        catch (ReflectiveOperationException e) {
            AmbleKit.LOGGER.error("Failed to process a registry container", (Throwable)e);
        }
    }

    public static <T> Class<T> conform(Class<?> input) {
        return input;
    }

    default public void start(int fields) {
    }

    default public void finish() {
    }
}

