/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.client.bedrock;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.amble.lib.AmbleKit;
import dev.amble.lib.client.bedrock.BedrockModel;
import dev.amble.lib.register.datapack.DatapackRegistry;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.lang3.NotImplementedException;

@Environment(value=EnvType.CLIENT)
public class BedrockModelRegistry
extends DatapackRegistry<BedrockModel>
implements SimpleSynchronousResourceReloadListener {
    private static final BedrockModelRegistry INSTANCE = new BedrockModelRegistry();

    private BedrockModelRegistry() {
        ResourceManagerHelper.get((PackType)PackType.CLIENT_RESOURCES).registerReloadListener((IdentifiableResourceReloadListener)this);
    }

    @Override
    public BedrockModel fallback() {
        throw new NotImplementedException();
    }

    public ResourceLocation getFabricId() {
        return AmbleKit.id("bedrock_model");
    }

    public void m_6213_(ResourceManager manager) {
        this.clearCache();
        for (ResourceLocation rawId : manager.m_214159_("bedrock", filename -> filename.m_135815_().endsWith("geo.json")).keySet()) {
            try {
                InputStream stream = ((Resource)manager.m_213713_(rawId).get()).m_215507_();
                try {
                    String path = rawId.m_135815_();
                    String idPath = path.substring("bedrock/".length(), path.length() - ".geo.json".length());
                    ResourceLocation id = ResourceLocation.m_214293_((String)rawId.m_135827_(), (String)idPath);
                    JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
                    BedrockModel model = BedrockModel.from(json, id);
                    this.register(model);
                    AmbleKit.LOGGER.info("Loaded bedrock model {} {}", (Object)id, (Object)model);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                AmbleKit.LOGGER.error("Error occurred while loading resource json {}", (Object)rawId.toString(), (Object)e);
            }
        }
    }

    @Override
    public void syncToClient(ServerPlayer player) {
        throw new UnsupportedOperationException("Client-side only registry");
    }

    @Override
    public void readFromServer(FriendlyByteBuf buf) {
        throw new UnsupportedOperationException("Client-side only registry");
    }

    public static BedrockModelRegistry getInstance() {
        return INSTANCE;
    }
}

