/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.client.bedrock;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import dev.amble.lib.api.Identifiable;
import dev.amble.lib.client.bedrock.BedrockAnimation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;

@Environment(value=EnvType.CLIENT)
public class BedrockModel
implements Identifiable {
    @SerializedName(value="format_version")
    public String version;
    @SerializedName(value="minecraft:geometry")
    public List<Geometry> geometry;
    private transient ResourceLocation id;

    public static BedrockModel from(JsonObject json, ResourceLocation id) {
        Gson gson = BedrockAnimation.GSON;
        BedrockModel model = (BedrockModel)gson.fromJson((JsonElement)json, BedrockModel.class);
        model.id = id;
        return model;
    }

    public LayerDefinition create() {
        MeshDefinition modelData = new MeshDefinition();
        HashMap<String, PartDefinition> parts = new HashMap<String, PartDefinition>();
        HashMap<String, Bone> bones = new HashMap<String, Bone>();
        try {
            Geometry geometry = this.geometry.get(0);
            ArrayList<Bone> geometryBones = new ArrayList<Bone>(geometry.bones);
            for (Bone bone : geometryBones) {
                if (bone.locators == null) continue;
                for (Map.Entry<String, LocatorBone> entry : bone.locators.entrySet()) {
                    Bone locatorBone = Bone.empty();
                    locatorBone.name = "internal_locator__" + entry.getKey();
                    locatorBone.parent = bone.name;
                    locatorBone.pivot = entry.getValue().offset;
                    locatorBone.rotation = entry.getValue().rotation;
                    geometryBones.add(locatorBone);
                }
            }
            Bone rootLocator = Bone.empty();
            rootLocator.name = "internal_locator__root";
            geometryBones.add(rootLocator);
            for (Bone bone : geometryBones) {
                bones.put(bone.name, bone);
                PartDefinition parentPart = bone.parent != null ? (PartDefinition)parts.get(bone.parent) : modelData.m_171576_();
                List<Float> boneRotation = bone.rotation;
                PartPose modelTransform = bone.parent == null ? PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f) : (boneRotation != null ? PartPose.m_171423_((float)(-(((Bone)bones.get((Object)bone.parent)).pivot.get(0).floatValue() - bone.pivot.get(0).floatValue())), (float)(((Bone)bones.get((Object)bone.parent)).pivot.get(1).floatValue() - bone.pivot.get(1).floatValue()), (float)(-(((Bone)bones.get((Object)bone.parent)).pivot.get(2).floatValue() - bone.pivot.get(2).floatValue())), (float)((float)Math.toRadians(boneRotation.get(0).floatValue())), (float)((float)Math.toRadians(boneRotation.get(1).floatValue())), (float)((float)Math.toRadians(boneRotation.get(2).floatValue()))) : PartPose.m_171419_((float)(-(((Bone)bones.get((Object)bone.parent)).pivot.get(0).floatValue() - bone.pivot.get(0).floatValue())), (float)(((Bone)bones.get((Object)bone.parent)).pivot.get(1).floatValue() - bone.pivot.get(1).floatValue()), (float)(-(((Bone)bones.get((Object)bone.parent)).pivot.get(2).floatValue() - bone.pivot.get(2).floatValue()))));
                CubeListBuilder modelPart = CubeListBuilder.m_171558_();
                ArrayList<CubeListBuilder> subParts = new ArrayList<CubeListBuilder>();
                ArrayList<PartPose> modelTransforms = new ArrayList<PartPose>();
                List<Cube> boneCubes = bone.cubes;
                if (boneCubes != null) {
                    for (Cube cube : boneCubes) {
                        List<Float> pivot;
                        CubeListBuilder subPart = cube.rotation != null ? CubeListBuilder.m_171558_() : modelPart;
                        List<Float> list = pivot = cube.pivot != null ? cube.pivot : bone.pivot;
                        if (cube.uv != null) {
                            subPart.m_171514_(cube.uv.get(0).intValue(), cube.uv.get(1).intValue());
                        }
                        if (cube.mirror) {
                            subPart.m_171480_();
                        }
                        if (cube.size != null && cube.origin != null) {
                            subPart.m_171488_(cube.origin.get(0).floatValue() - pivot.get(0).floatValue(), -(cube.origin.get(1).floatValue() - pivot.get(1).floatValue() + cube.size.get(1).floatValue()), cube.origin.get(2).floatValue() - pivot.get(2).floatValue(), cube.size.get(0).floatValue(), cube.size.get(1).floatValue(), cube.size.get(2).floatValue(), new CubeDeformation(cube.inflate));
                        }
                        if (cube.mirror) {
                            subPart.m_171555_(false);
                        }
                        if (subPart == modelPart) continue;
                        modelTransforms.add(PartPose.m_171423_((float)(-(bone.pivot.get(0).floatValue() - cube.pivot.get(0).floatValue())), (float)(bone.pivot.get(1).floatValue() - cube.pivot.get(1).floatValue()), (float)(-(bone.pivot.get(2).floatValue() - cube.pivot.get(2).floatValue())), (float)((float)Math.toRadians(cube.rotation.get(0).floatValue())), (float)((float)Math.toRadians(cube.rotation.get(1).floatValue())), (float)((float)Math.toRadians(cube.rotation.get(2).floatValue()))));
                        subParts.add(subPart);
                    }
                }
                parts.put(bone.name, parentPart.m_171599_(bone.name, modelPart, modelTransform));
                int counter = 0;
                for (int index = 0; index < subParts.size(); ++index) {
                    ((PartDefinition)parts.get(bone.name)).m_171599_(bone.name + counter++, (CubeListBuilder)subParts.get(index), (PartPose)modelTransforms.get(index));
                }
            }
            return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)geometry.description.textureWidth, (int)geometry.description.textureHeight);
        }
        catch (Exception e) {
            if (this.geometry != null && !this.geometry.isEmpty()) {
                throw new IllegalArgumentException("Error creating LayerDefinition with identifier " + this.geometry.get((int)0).description.identifier, e);
            }
            throw new IllegalArgumentException("Error creating LayerDefinition", e);
        }
    }

    public String toString() {
        return "BedrockModel{version='" + this.version + "', geometry=" + this.geometry + "}";
    }

    @Override
    public ResourceLocation id() {
        if (this.id == null) {
            throw new IllegalStateException("Model identifier is not set.");
        }
        return this.id;
    }

    public static class Geometry {
        public Description description;
        public List<Bone> bones;

        public String toString() {
            return "Geometry{description=" + this.description + ", bones=" + this.bones + "}";
        }
    }

    public static class Bone {
        public String name;
        public String parent;
        public List<Float> pivot;
        public List<Float> rotation;
        public List<Cube> cubes;
        public Map<String, LocatorBone> locators;

        public Bone() {
            this("", null, List.of(), null, null, null);
        }

        public Bone(String name, String parent, List<Float> pivot, List<Float> rotation, List<Cube> cubes, Map<String, LocatorBone> locators) {
            this.name = name;
            this.parent = parent;
            this.pivot = pivot;
            this.rotation = rotation;
            this.cubes = cubes;
            this.locators = locators;
        }

        public String toString() {
            return "Bone{name='" + this.name + "', parent='" + this.parent + "', pivot=" + this.pivot + ", rotation=" + this.rotation + ", cubes=" + this.cubes + ", locators=" + this.locators + "}";
        }

        public static Bone empty() {
            return new Bone();
        }
    }

    public static class LocatorBone {
        public List<Float> offset = List.of(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));
        public List<Float> rotation = List.of(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));

        public String toString() {
            return "LocatorBone{offset=" + this.offset + ", rotation=" + this.rotation + "}";
        }

        public static class Adapter
        implements JsonDeserializer<LocatorBone> {
            public LocatorBone deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                List<Float> rotation;
                List<Float> offset;
                if (json.isJsonArray()) {
                    JsonArray arr = json.getAsJsonArray();
                    offset = Arrays.asList(Float.valueOf(arr.get(0).getAsFloat()), Float.valueOf(arr.get(1).getAsFloat()), Float.valueOf(arr.get(2).getAsFloat()));
                    rotation = Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));
                } else {
                    JsonObject obj = json.getAsJsonObject();
                    JsonArray offsetArr = obj.has("offset") ? obj.getAsJsonArray("offset") : null;
                    JsonArray rotationArr = obj.has("rotation") ? obj.getAsJsonArray("rotation") : null;
                    offset = offsetArr != null ? Adapter.toFloatList(offsetArr) : Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));
                    rotation = rotationArr != null ? Adapter.toFloatList(rotationArr) : Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));
                }
                LocatorBone bone = new LocatorBone();
                bone.offset = offset;
                bone.rotation = rotation;
                return bone;
            }

            public static List<Float> toFloatList(JsonArray arr) {
                return Arrays.asList(Float.valueOf(arr.get(0).getAsFloat()), Float.valueOf(arr.get(1).getAsFloat()), Float.valueOf(arr.get(2).getAsFloat()));
            }
        }
    }

    public record Cube(List<Float> origin, List<Float> size, List<Float> pivot, List<Float> rotation, List<Integer> uv, float inflate, boolean mirror) {
        @Override
        public String toString() {
            return "Cube{origin=" + this.origin + ", size=" + this.size + ", pivot=" + this.pivot + ", rotation=" + this.rotation + ", uv=" + this.uv + ", inflate=" + this.inflate + ", mirror=" + this.mirror + "}";
        }
    }

    public static class Description {
        public String identifier;
        @SerializedName(value="texture_width")
        public int textureWidth;
        @SerializedName(value="texture_height")
        public int textureHeight;
        @SerializedName(value="visible_bounds_width")
        public float visibleBoundsWidth;
        @SerializedName(value="visible_bounds_height")
        public float visibleBoundsHeight;
        @SerializedName(value="visible_bounds_offset")
        public List<Float> visibleBoundsOffset;

        public String toString() {
            return "Description{identifier='" + this.identifier + "', textureWidth=" + this.textureWidth + ", textureHeight=" + this.textureHeight + ", visibleBoundsWidth=" + this.visibleBoundsWidth + ", visibleBoundsHeight=" + this.visibleBoundsHeight + ", visibleBoundsOffset=" + this.visibleBoundsOffset + "}";
        }
    }
}

