/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.client.bedrock;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.amble.lib.AmbleKit;
import dev.amble.lib.client.bedrock.BedrockAnimation;
import dev.amble.lib.client.bedrock.BedrockAnimationReference;
import dev.amble.lib.register.Registry;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

@Environment(value=EnvType.CLIENT)
public class BedrockAnimationRegistry
implements SimpleSynchronousResourceReloadListener,
Registry {
    private static final BedrockAnimationRegistry INSTANCE = new BedrockAnimationRegistry();
    private final Map<String, BedrockAnimation.Group> groups = new HashMap<String, BedrockAnimation.Group>();

    public BedrockAnimationRegistry() {
        ResourceManagerHelper.get((PackType)PackType.CLIENT_RESOURCES).registerReloadListener((IdentifiableResourceReloadListener)this);
    }

    public BedrockAnimation get(String fileName, String animationName) {
        BedrockAnimation.Group group = this.groups.get(fileName);
        if (group == null) {
            return null;
        }
        return group.animations.get(animationName);
    }

    public BedrockAnimation get(BedrockAnimationReference data) {
        return this.get(data.fileName(), data.animationName());
    }

    public ResourceLocation getFabricId() {
        return AmbleKit.id("bedrock_animation");
    }

    public void m_6213_(ResourceManager manager) {
        int animationCount = 0;
        this.groups.clear();
        for (ResourceLocation rawId : manager.m_214159_("bedrock", filename -> filename.m_135815_().endsWith(".animation.json")).keySet()) {
            try {
                InputStream stream = ((Resource)manager.m_213713_(rawId).get()).m_215507_();
                try {
                    JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
                    BedrockAnimation.Group group = (BedrockAnimation.Group)BedrockAnimation.GSON.fromJson((JsonElement)json, BedrockAnimation.Group.class);
                    group.animations.forEach((name, animation) -> {
                        animation.name = name;
                    });
                    String groupName = rawId.m_135815_().substring(rawId.m_135815_().lastIndexOf("/") + 1).replace(".animation.json", "");
                    this.groups.put(groupName, group);
                    animationCount += group.animations.size();
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                AmbleKit.LOGGER.error("Error occurred while loading resource json {}", (Object)rawId.toString(), (Object)e);
            }
        }
        AmbleKit.LOGGER.info("Loaded {} animations from {} groups", (Object)animationCount, (Object)this.groups.size());
    }

    public static BedrockAnimationRegistry getInstance() {
        return INSTANCE;
    }
}

