/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.client.bedrock;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.amble.lib.client.bedrock.BedrockAnimation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.world.phys.Vec3;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;

@Environment(value=EnvType.CLIENT)
public class BedrockAnimationAdapter
implements JsonDeserializer<BedrockAnimation> {
    public static final BedrockAnimationAdapter INSTANCE = new BedrockAnimationAdapter();

    public BedrockAnimation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            throw new IllegalStateException("animation json could not be parsed");
        }
        JsonObject jsonObj = json.getAsJsonObject();
        double animationLength = jsonObj.has("animation_length") ? jsonObj.get("animation_length").getAsDouble() : -1.0;
        boolean shouldLoop = animationLength > 0.0 && jsonObj.has("loop") && jsonObj.get("loop").getAsBoolean();
        HashMap<String, BedrockAnimation.BoneTimeline> boneTimelines = new HashMap<String, BedrockAnimation.BoneTimeline>();
        if (jsonObj.has("bones")) {
            for (Map.Entry entry : jsonObj.getAsJsonObject("bones").entrySet()) {
                boneTimelines.put((String)entry.getKey(), this.deserializeBoneTimeline(((JsonElement)entry.getValue()).getAsJsonObject()));
            }
        }
        return new BedrockAnimation(shouldLoop, animationLength, boneTimelines);
    }

    private BedrockAnimation.BoneTimeline deserializeBoneTimeline(JsonObject bone) {
        JsonElement json;
        BedrockAnimation.BoneValue positions = BedrockAnimation.EmptyBoneValue.INSTANCE;
        BedrockAnimation.BoneValue rotations = BedrockAnimation.EmptyBoneValue.INSTANCE;
        BedrockAnimation.BoneValue scale = BedrockAnimation.EmptyBoneValue.INSTANCE;
        if (bone.has("position") && bone.get("position").isJsonObject()) {
            positions = this.deserializeKeyframe(bone.getAsJsonObject("position"), BedrockAnimation.Transformation.POSITION);
        }
        if (bone.has("rotation") && bone.get("rotation").isJsonObject()) {
            rotations = this.deserializeKeyframe(bone.getAsJsonObject("rotation"), BedrockAnimation.Transformation.ROTATION);
        }
        if (bone.has("scale") && (json = bone.get("scale")).isJsonObject()) {
            scale = this.deserializeKeyframe(json.getAsJsonObject(), BedrockAnimation.Transformation.SCALE);
        }
        return new BedrockAnimation.BoneTimeline(positions, rotations, scale);
    }

    private BedrockAnimation.KeyFrameBoneValue deserializeKeyframe(JsonObject frames, BedrockAnimation.Transformation transformation) {
        BedrockAnimation.KeyFrameBoneValue keyframes = new BedrockAnimation.KeyFrameBoneValue();
        for (Map.Entry entry : frames.entrySet()) {
            double time = Double.parseDouble((String)entry.getKey());
            JsonElement keyframeJson = (JsonElement)entry.getValue();
            if (keyframeJson.isJsonObject()) {
                BedrockAnimation.InterpolationType type;
                JsonObject kfObj = keyframeJson.getAsJsonObject();
                BedrockAnimation.InterpolationType interpolationType = type = "catmullrom".equals(kfObj.has("lerp_mode") ? kfObj.get("lerp_mode").getAsString() : "linear") ? BedrockAnimation.InterpolationType.SMOOTH : BedrockAnimation.InterpolationType.LINEAR;
                if (kfObj.has("post")) {
                    JsonElement post = kfObj.get("post");
                    keyframes.put(time, new BedrockAnimation.JumpKeyFrame(time, transformation, type, this.deserializeSimpleBoneValue(kfObj.has("pre") ? kfObj.getAsJsonArray("pre") : post.getAsJsonArray(), transformation), this.deserializeSimpleBoneValue(post.getAsJsonArray(), transformation)));
                    continue;
                }
                if (!kfObj.has("pre")) continue;
                JsonElement pre = kfObj.get("pre");
                keyframes.put(time, new BedrockAnimation.JumpKeyFrame(time, transformation, type, this.deserializeSimpleBoneValue(pre.getAsJsonArray(), transformation), this.deserializeSimpleBoneValue(kfObj.has("post") ? kfObj.getAsJsonArray("post") : pre.getAsJsonArray(), transformation)));
                continue;
            }
            keyframes.put(time, new BedrockAnimation.SimpleKeyFrame(time, transformation, BedrockAnimation.InterpolationType.LINEAR, this.deserializeSimpleBoneValue(keyframeJson.getAsJsonArray(), transformation)));
        }
        return keyframes;
    }

    private BedrockAnimation.SimpleBoneValue deserializeSimpleBoneValue(JsonArray array, BedrockAnimation.Transformation transformation) {
        return new BedrockAnimation.SimpleBoneValue(new Vec3((double)BedrockAnimationAdapter.parseMath(String.valueOf(array.get(0))), (double)BedrockAnimationAdapter.parseMath(String.valueOf(array.get(1))), (double)BedrockAnimationAdapter.parseMath(String.valueOf(array.get(2)))), transformation);
    }

    public static float parseMath(String data) {
        Expression expression = new ExpressionBuilder(data).build();
        double result = expression.evaluate();
        return (float)result;
    }
}

