/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.client.bedrock;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import dev.amble.lib.AmbleKit;
import dev.amble.lib.client.bedrock.BedrockAnimationAdapter;
import dev.amble.lib.client.bedrock.BedrockModel;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.phys.Vec3;

@Environment(value=EnvType.CLIENT)
public class BedrockAnimation {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(BedrockModel.LocatorBone.class, (Object)new BedrockModel.LocatorBone.Adapter()).registerTypeAdapter(BedrockAnimation.class, (Object)new BedrockAnimationAdapter()).create();
    public final boolean shouldLoop;
    public final double animationLength;
    public final Map<String, BoneTimeline> boneTimelines;
    public String name;

    public BedrockAnimation(boolean shouldLoop, double animationLength, Map<String, BoneTimeline> boneTimelines) {
        this.shouldLoop = shouldLoop;
        this.animationLength = animationLength;
        this.boneTimelines = boneTimelines;
    }

    @Environment(value=EnvType.CLIENT)
    public void apply(ModelPart root, int totalTicks, float rawDelta) {
        float ticks = (float)((double)((float)totalTicks / 20.0f) % this.animationLength) * 20.0f;
        float delta = rawDelta / 10.0f;
        this.boneTimelines.forEach((boneName, timeline) -> {
            try {
                ModelPart bone = root.m_171331_().filter(part -> part.m_233562_(boneName)).findFirst().map(part -> part.m_171324_(boneName)).orElse(null);
                if (bone == null) {
                    if (boneName == "root") {
                        bone = root;
                    } else {
                        throw new IllegalStateException("Bone " + boneName + " not found in model. If this is the root part, ensure it is named 'root'.");
                    }
                }
                if (!timeline.position.isEmpty()) {
                    Vec3 position = timeline.position.resolve((double)ticks / 20.0 + (double)delta);
                    bone.f_104200_ += (float)position.f_82479_;
                    bone.f_104201_ += (float)position.f_82480_;
                    bone.f_104202_ += (float)position.f_82481_;
                }
                if (!timeline.rotation.isEmpty()) {
                    Vec3 rotation = timeline.rotation.resolve((double)ticks / 20.0 + (double)delta);
                    bone.f_104203_ += (float)Math.toRadians((float)rotation.f_82479_);
                    bone.f_104204_ += (float)Math.toRadians((float)rotation.f_82480_);
                    bone.f_104205_ += (float)Math.toRadians((float)rotation.f_82481_);
                }
                if (!timeline.scale.isEmpty()) {
                    Vec3 scale = timeline.scale.resolve((double)ticks / 20.0 + (double)delta);
                    bone.f_233553_ *= (float)scale.f_82479_;
                    bone.f_233554_ *= (float)scale.f_82480_;
                    bone.f_233555_ *= (float)scale.f_82481_;
                }
            }
            catch (Exception e) {
                AmbleKit.LOGGER.error("Failed apply animation to {} in model. Skipping animation application for this bone.", boneName, (Object)e);
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    public void apply(ModelPart root, AnimationState state, float progress, float speedMultiplier) {
        state.m_216974_(progress, speedMultiplier);
        float ticks = this.shouldLoop ? (float)((double)((float)state.m_216981_() / 1000.0f) % this.animationLength) * 20.0f : (float)state.m_216981_();
        state.m_216979_(s -> this.apply(root, (int)ticks, 0.0f));
    }

    public record BoneTimeline(BoneValue position, BoneValue rotation, BoneValue scale) {
    }

    public static interface BoneValue {
        public Vec3 resolve(double var1);

        public boolean isEmpty();
    }

    public static enum Transformation {
        POSITION,
        ROTATION,
        SCALE;

    }

    public static enum InterpolationType {
        SMOOTH,
        LINEAR;

    }

    public static class JumpKeyFrame
    extends KeyFrame {
        private final BoneValue pre;
        private final BoneValue post;

        public JumpKeyFrame(double time, Transformation transformation, InterpolationType interpolationType, BoneValue pre, BoneValue post) {
            super(time, transformation, interpolationType);
            this.pre = pre;
            this.post = post;
        }

        @Override
        public BoneValue getPre() {
            return this.pre;
        }

        @Override
        public BoneValue getPost() {
            return this.post;
        }
    }

    public static class SimpleKeyFrame
    extends KeyFrame {
        public final BoneValue data;

        public SimpleKeyFrame(double time, Transformation transformation, InterpolationType interpolationType, BoneValue data) {
            super(time, transformation, interpolationType);
            this.data = data;
        }

        @Override
        public BoneValue getPre() {
            return this.data;
        }

        @Override
        public BoneValue getPost() {
            return this.data;
        }
    }

    public static abstract class KeyFrame {
        public final double time;
        public final Transformation transformation;
        public final InterpolationType interpolationType;

        public KeyFrame(double time, Transformation transformation, InterpolationType interpolationType) {
            this.time = time;
            this.transformation = transformation;
            this.interpolationType = interpolationType;
        }

        public abstract BoneValue getPre();

        public abstract BoneValue getPost();
    }

    public static class EmptyBoneValue
    implements BoneValue {
        public static final EmptyBoneValue INSTANCE = new EmptyBoneValue();

        private EmptyBoneValue() {
        }

        @Override
        public Vec3 resolve(double time) {
            return Vec3.f_82478_;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }

    public static class KeyFrameBoneValue
    extends TreeMap<Double, KeyFrame>
    implements BoneValue {
        private KeyFrame getAtIndex(SortedMap<Double, KeyFrame> map, Integer index) {
            if (index == null) {
                return null;
            }
            if (index < 0 || index >= map.size()) {
                return null;
            }
            Double key = new ArrayList<Double>(map.keySet()).get(index);
            return (KeyFrame)map.get(key);
        }

        @Override
        public Vec3 resolve(double time) {
            Vec3 beforeData;
            ArrayList keyList = new ArrayList(this.keySet());
            Integer afterIndex = null;
            for (int i = 0; i < keyList.size(); ++i) {
                if (!((Double)keyList.get(i) > time)) continue;
                afterIndex = i;
                break;
            }
            Integer beforeIndex = afterIndex == null ? Integer.valueOf(this.size() - 1) : (afterIndex == 0 ? null : Integer.valueOf(afterIndex - 1));
            KeyFrame after = this.getAtIndex(this, afterIndex);
            KeyFrame before = this.getAtIndex(this, beforeIndex);
            Vec3 afterData = after != null && after.getPre() != null ? after.getPre().resolve(time) : Vec3.f_82478_;
            Vec3 vec3 = beforeData = before != null && before.getPost() != null ? before.getPost().resolve(time) : Vec3.f_82478_;
            if (before != null || after != null) {
                boolean smoothAfter;
                boolean smoothBefore = before != null && before.interpolationType == InterpolationType.SMOOTH;
                boolean bl = smoothAfter = after != null && after.interpolationType == InterpolationType.SMOOTH;
                if (smoothBefore || smoothAfter) {
                    if (before != null && after != null) {
                        Integer beforePlusIndex = beforeIndex == 0 ? null : Integer.valueOf(beforeIndex - 1);
                        KeyFrame beforePlus = this.getAtIndex(this, beforePlusIndex);
                        Integer afterPlusIndex = afterIndex == this.size() - 1 ? null : Integer.valueOf(afterIndex + 1);
                        KeyFrame afterPlus = this.getAtIndex(this, afterPlusIndex);
                        Vec3 beforePlusData = beforePlus != null && beforePlus.getPost() != null ? beforePlus.getPost().resolve(time) : beforeData;
                        Vec3 afterPlusData = afterPlus != null && afterPlus.getPre() != null ? afterPlus.getPre().resolve(time) : afterData;
                        double t = (time - before.time) / (after.time - before.time);
                        return new Vec3((double)Mth.m_216244_((float)((float)t), (float)((float)beforePlusData.f_82479_), (float)((float)beforeData.f_82479_), (float)((float)afterData.f_82479_), (float)((float)afterPlusData.f_82479_)), (double)Mth.m_216244_((float)((float)t), (float)((float)beforePlusData.f_82480_), (float)((float)beforeData.f_82480_), (float)((float)afterData.f_82480_), (float)((float)afterPlusData.f_82480_)), (double)Mth.m_216244_((float)((float)t), (float)((float)beforePlusData.f_82481_), (float)((float)beforeData.f_82481_), (float)((float)afterData.f_82481_), (float)((float)afterPlusData.f_82481_)));
                    }
                    if (before != null) {
                        return beforeData;
                    }
                    return afterData;
                }
                if (before != null && after != null) {
                    double alpha = Mth.m_14139_((double)time, (double)before.time, (double)after.time);
                    return new Vec3(beforeData.m_7096_() + (afterData.m_7096_() - beforeData.m_7096_()) * alpha, beforeData.m_7098_() + (afterData.m_7098_() - beforeData.m_7098_()) * alpha, beforeData.m_7094_() + (afterData.m_7094_() - beforeData.m_7094_()) * alpha);
                }
                if (before != null) {
                    return beforeData;
                }
                return afterData;
            }
            return new Vec3(0.0, 0.0, 0.0);
        }
    }

    public static class SimpleBoneValue
    implements BoneValue {
        public final Vec3 value;
        public final Transformation transformation;

        public SimpleBoneValue(Vec3 value, Transformation transformation) {
            this.value = value.m_82542_(1.0, transformation == Transformation.POSITION ? -1.0 : 1.0, 1.0);
            this.transformation = transformation;
        }

        @Override
        public Vec3 resolve(double time) {
            return this.value;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    public static class Group {
        @SerializedName(value="format_version")
        public String version;
        public Map<String, BedrockAnimation> animations;
    }
}

