/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.api;

import dev.amble.lib.data.DirectedGlobalPos;
import dev.amble.lib.util.ServerLifecycleHooks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class WorldUtil {
    private static final int SAFE_RADIUS = 3;

    public static DirectedGlobalPos locateSafe(DirectedGlobalPos cached, GroundSearch vSearch, boolean hSearch) {
        BlockPos temp;
        BlockPos pos;
        ServerLevel world = ServerLifecycleHooks.get().m_129880_(cached.getDimension());
        if (WorldUtil.isSafe((Level)world, pos = cached.getPos())) {
            return cached;
        }
        if (hSearch && (temp = WorldUtil.findSafeXZ(world, pos, 3)) != null) {
            return cached.pos(temp);
        }
        int x = pos.m_123341_();
        int z = pos.m_123343_();
        int y = switch (vSearch) {
            default -> throw new IncompatibleClassChangeError();
            case GroundSearch.CEILING -> WorldUtil.findSafeTopY(world, pos);
            case GroundSearch.FLOOR -> WorldUtil.findSafeBottomY(world, pos);
            case GroundSearch.MEDIAN -> WorldUtil.findSafeMedianY(world, pos);
            case GroundSearch.NONE -> pos.m_123342_();
        };
        return cached.pos(x, y, z);
    }

    private static BlockPos findSafeXZ(ServerLevel world, BlockPos original, int radius) {
        BlockPos.MutableBlockPos pos = original.m_122032_();
        int minX = pos.m_123341_() - radius;
        int maxX = pos.m_123341_() + radius;
        int minZ = pos.m_123343_() - radius;
        int maxZ = pos.m_123343_() + radius;
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                pos.m_142451_(x).m_142443_(z);
                if (!WorldUtil.isSafe((Level)world, (BlockPos)pos)) continue;
                return pos;
            }
        }
        return null;
    }

    private static int findSafeMedianY(ServerLevel world, BlockPos pos) {
        BlockPos upCursor = pos;
        BlockState floorUp = world.m_8055_(upCursor.m_7495_());
        BlockState curUp = world.m_8055_(upCursor);
        BlockState aboveUp = world.m_8055_(upCursor.m_7494_());
        BlockPos downCursor = pos;
        BlockState floorDown = world.m_8055_(downCursor.m_7495_());
        BlockState curDown = world.m_8055_(downCursor);
        BlockState aboveDown = world.m_8055_(downCursor.m_7494_());
        while (true) {
            boolean canGoDown;
            boolean canGoUp = upCursor.m_123342_() < world.m_151558_();
            boolean bl = canGoDown = downCursor.m_123342_() > world.m_141937_();
            if (!canGoUp && !canGoDown) {
                return pos.m_123342_();
            }
            if (canGoUp) {
                if (WorldUtil.isSafe(floorUp, curUp, aboveUp)) {
                    return upCursor.m_123342_() - 1;
                }
                upCursor = upCursor.m_7494_();
                floorUp = curUp;
                curUp = aboveUp;
                aboveUp = world.m_8055_(upCursor);
            }
            if (!canGoDown) continue;
            if (WorldUtil.isSafe(floorDown, curDown, aboveDown)) {
                return downCursor.m_123342_() + 1;
            }
            downCursor = downCursor.m_7495_();
            curDown = aboveDown;
            aboveDown = floorDown;
            floorDown = world.m_8055_(downCursor);
        }
    }

    private static int findSafeBottomY(ServerLevel world, BlockPos pos) {
        BlockPos cursor = pos.m_175288_(world.m_141937_() + 2);
        BlockState floor = world.m_8055_(cursor.m_7495_());
        BlockState current = world.m_8055_(cursor);
        BlockState above = world.m_8055_(cursor.m_7494_());
        while (cursor.m_123342_() <= world.m_151558_()) {
            if (WorldUtil.isSafe(floor, current, above)) {
                return cursor.m_123342_() - 1;
            }
            cursor = cursor.m_7494_();
            floor = current;
            current = above;
            above = world.m_8055_(cursor);
        }
        return pos.m_123342_();
    }

    private static int findSafeTopY(ServerLevel world, BlockPos pos) {
        int x = pos.m_123341_();
        int z = pos.m_123343_();
        return world.m_6325_(SectionPos.m_123171_((int)x), SectionPos.m_123171_((int)z)).m_5885_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x & 0xF, z & 0xF) + 1;
    }

    private static boolean isSafe(BlockState floor, BlockState block1, BlockState block2) {
        return WorldUtil.isFloor(floor) && !block1.m_280555_() && !block2.m_280555_();
    }

    private static boolean isSafe(BlockState block1, BlockState block2) {
        return !block1.m_280555_() && !block2.m_280555_();
    }

    private static boolean isFloor(BlockState floor) {
        return floor.m_280555_();
    }

    private static boolean isSafe(Level world, BlockPos pos) {
        BlockState floor = world.m_8055_(pos.m_7495_());
        if (!WorldUtil.isFloor(floor)) {
            return false;
        }
        BlockState curUp = world.m_8055_(pos);
        BlockState aboveUp = world.m_8055_(pos.m_7494_());
        return WorldUtil.isSafe(curUp, aboveUp);
    }

    public static Component worldText(ResourceKey<Level> key) {
        return Component.m_264568_((String)key.m_135782_().m_214296_("dimension"), (String)WorldUtil.fakeTranslate(key));
    }

    private static String fakeTranslate(ResourceKey<Level> id) {
        return WorldUtil.fakeTranslate(id.m_135782_());
    }

    private static String fakeTranslate(ResourceLocation id) {
        return WorldUtil.fakeTranslate(id.m_135815_());
    }

    private static String fakeTranslate(String path) {
        CharSequence[] words = path.split("_");
        for (int i = 0; i < words.length; ++i) {
            words[i] = ((String)words[i]).substring(0, 1).toUpperCase() + ((String)words[i]).substring(1).toLowerCase();
        }
        return String.join((CharSequence)" ", words);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum GroundSearch implements StringRepresentable
    {
        NONE{

            @Override
            public GroundSearch next() {
                return FLOOR;
            }
        }
        ,
        FLOOR{

            @Override
            public GroundSearch next() {
                return CEILING;
            }
        }
        ,
        CEILING{

            @Override
            public GroundSearch next() {
                return MEDIAN;
            }
        }
        ,
        MEDIAN{

            @Override
            public GroundSearch next() {
                return NONE;
            }
        };


        public String m_7912_() {
            return this.toString();
        }

        public abstract GroundSearch next();
    }
}

