/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public record RopeModel(float[] vertices, float[] uvs) {
    public static Builder builder(int initialCapacity) {
        return new Builder(initialCapacity);
    }

    public void render(VertexConsumer buffer, PoseStack poseStack, int bLight0, int bLight1, int sLight0, int sLight1) {
        Matrix4f modelMatrix = poseStack.m_85850_().m_252922_();
        Matrix3f normalMatrix = poseStack.m_85850_().m_252943_();
        int count = this.vertices.length / 3;
        for (int i = 0; i < count; ++i) {
            float f = (float)i % ((float)count / 2.0f) / ((float)count / 2.0f);
            int blockLight = (int)Mth.m_14179_((float)f, (float)bLight0, (float)bLight1);
            int skyLight = (int)Mth.m_14179_((float)f, (float)sLight0, (float)sLight1);
            int light = LightTexture.m_109885_((int)blockLight, (int)skyLight);
            buffer.m_252986_(modelMatrix, this.vertices[i * 3], this.vertices[i * 3 + 1], this.vertices[i * 3 + 2]).m_193479_(-1).m_7421_(this.uvs[i * 2], this.uvs[i * 2 + 1]).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normalMatrix, 1.0f, 0.35f, 0.0f).m_5752_();
        }
    }

    public static class Builder {
        private final List<Float> vertices;
        private final List<Float> uvs;
        private int size;

        public Builder(int initialCapacity) {
            this.vertices = new ArrayList<Float>(initialCapacity * 3);
            this.uvs = new ArrayList<Float>(initialCapacity * 2);
        }

        public Builder vertex(float x, float y, float z) {
            this.vertices.add(Float.valueOf(x));
            this.vertices.add(Float.valueOf(y));
            this.vertices.add(Float.valueOf(z));
            return this;
        }

        public Builder uv(float u, float v) {
            this.uvs.add(Float.valueOf(u));
            this.uvs.add(Float.valueOf(v));
            return this;
        }

        public void next() {
            ++this.size;
        }

        public RopeModel build() {
            if (this.vertices.size() != this.size * 3) {
                // empty if block
            }
            if (this.uvs.size() != this.size * 2) {
                // empty if block
            }
            return new RopeModel(this.toFloatArray(this.vertices), this.toFloatArray(this.uvs));
        }

        private float[] toFloatArray(List<Float> floats) {
            float[] array = new float[floats.size()];
            int i = 0;
            for (float f : floats) {
                array[i++] = f;
            }
            return array;
        }
    }
}

