/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.sodiumextra.mixin.optimizations.fast_weather;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import me.flashyreese.mods.sodiumextra.client.render.vertex.formats.WeatherVertex;
import me.flashyreese.mods.sodiumextra.common.util.Utils;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class}, priority=1500)
public class MixinWorldRenderer {
    @Shadow
    @Final
    private static ResourceLocation f_109459_;
    @Shadow
    @Final
    private static ResourceLocation f_109460_;
    @Unique
    private final Long2ReferenceMap<Biome> biomeLong2ReferenceMap = new Long2ReferenceOpenHashMap();
    @Shadow
    @Final
    private Minecraft f_109461_;
    @Shadow
    private int f_109477_;
    @Shadow
    @Final
    private float[] f_109451_;
    @Shadow
    @Final
    private float[] f_109452_;

    @Inject(method={"renderWeather"}, at={@At(value="HEAD")}, cancellable=true)
    public void sodiumExtra$renderWeather(LightTexture manager, float tickDelta, double cameraX, double cameraY, double cameraZ, CallbackInfo ci) {
        assert (this.f_109461_.f_91073_ != null);
        float f = this.f_109461_.f_91073_.m_46722_(tickDelta);
        if (!(f <= 0.0f)) {
            manager.m_109896_();
            ClientLevel world = this.f_109461_.f_91073_;
            int abX = Mth.m_14107_((double)cameraX);
            int abY = Mth.m_14107_((double)cameraY);
            int abZ = Mth.m_14107_((double)cameraZ);
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder bufferBuilder = tessellator.m_85915_();
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            int l = 5;
            if (Minecraft.m_91405_()) {
                l = 10;
            }
            RenderSystem.depthMask((boolean)Minecraft.m_91085_());
            int m = -1;
            float g = (float)this.f_109477_ + tickDelta;
            RenderSystem.setShader(GameRenderer::m_172829_);
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (int z = abZ - l; z <= abZ + l; ++z) {
                for (int x = abX - l; x <= abX + l; ++x) {
                    int p = (z - abZ + 16) * 32 + x - abX + 16;
                    double d = (double)this.f_109451_[p] * 0.5;
                    double e = (double)this.f_109452_[p] * 0.5;
                    mutable.m_122169_((double)x, cameraY, (double)z);
                    long biomePacked = Utils.packPosition(x, z);
                    Biome biome = (Biome)this.biomeLong2ReferenceMap.computeIfAbsent(biomePacked, arg_0 -> MixinWorldRenderer.lambda$sodiumExtra$renderWeather$0((Level)world, mutable, arg_0));
                    if (!biome.m_264473_()) continue;
                    int q = world.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z);
                    int r = abY - l;
                    int s = abY + l;
                    if (r < q) {
                        r = q;
                    }
                    if (s < q) {
                        s = q;
                    }
                    int t = Math.max(q, abY);
                    if (r == s) continue;
                    RandomSource random = RandomSource.m_216335_((long)((long)x * (long)x * 3121L + (long)x * 45238971L ^ (long)z * (long)z * 418711L + (long)z * 13761L));
                    mutable.m_122178_(x, r, z);
                    Biome.Precipitation precipitation = biome.m_264600_((BlockPos)mutable);
                    if (precipitation == Biome.Precipitation.RAIN) {
                        if (m != 0) {
                            if (m >= 0) {
                                tessellator.m_85914_();
                            }
                            m = 0;
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)f_109459_);
                            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                        }
                        int u = this.f_109477_ + x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761 & 0x1F;
                        float rainOffset = -((float)u + tickDelta) / 32.0f * (3.0f + random.m_188501_());
                        double v = (double)x + 0.5 - cameraX;
                        double w = (double)z + 0.5 - cameraZ;
                        float distance = (float)Math.sqrt(v * v + w * w) / (float)l;
                        float y = ((1.0f - distance * distance) * 0.5f + 0.5f) * f;
                        mutable.m_122178_(x, t, z);
                        int light = LevelRenderer.m_109541_((BlockAndTintGetter)world, (BlockPos)mutable);
                        VertexBufferWriter writer = VertexBufferWriter.of((VertexConsumer)bufferBuilder);
                        int color = ColorABGR.pack((float)1.0f, (float)1.0f, (float)1.0f, (float)y);
                        this.writeVertices(cameraX, cameraY, cameraZ, z, x, d, e, r, s, rainOffset, light, writer, color);
                        continue;
                    }
                    if (precipitation != Biome.Precipitation.SNOW) continue;
                    if (m != 1) {
                        if (m >= 0) {
                            tessellator.m_85914_();
                        }
                        m = 1;
                        RenderSystem.setShaderTexture((int)0, (ResourceLocation)f_109460_);
                        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                    }
                    float snowOffset = (float)(random.m_188500_() + (double)g * 0.01 * (double)((float)random.m_188583_()));
                    double ac = (double)x + 0.5 - cameraX;
                    double ad = (double)z + 0.5 - cameraZ;
                    float y = (float)Math.sqrt(ac * ac + ad * ad) / (float)l;
                    float ae = ((1.0f - y * y) * 0.3f + 0.5f) * f;
                    mutable.m_122178_(x, t, z);
                    int af = LevelRenderer.m_109541_((BlockAndTintGetter)world, (BlockPos)mutable);
                    int ag = af >> 16 & 0xFFFF;
                    int ah = af & 0xFFFF;
                    int ai = (ag * 3 + 240) / 4;
                    int aj = (ah * 3 + 240) / 4;
                    VertexBufferWriter writer = VertexBufferWriter.of((VertexConsumer)bufferBuilder);
                    int color = ColorABGR.pack((float)1.0f, (float)1.0f, (float)1.0f, (float)ae);
                    int light = Utils.packLight(aj, ai);
                    this.writeVertices(cameraX, cameraY, cameraZ, z, x, d, e, r, s, snowOffset, light, writer, color);
                }
            }
            if (m >= 0) {
                tessellator.m_85914_();
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            manager.m_109891_();
        }
        ci.cancel();
    }

    @Inject(method={"reload()V"}, at={@At(value="TAIL")})
    private void postReload(CallbackInfo ci) {
        this.biomeLong2ReferenceMap.clear();
    }

    @Unique
    private void writeVertices(double cameraX, double cameraY, double cameraZ, int n, int o, double d, double e, int r, int s, float h, int light, VertexBufferWriter writer, int color) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(112);
            WeatherVertex.put(ptr, (float)((double)o - cameraX - d + 0.5), (float)((double)s - cameraY), (float)((double)n - cameraZ - e + 0.5), color, 0.0f, (float)r * 0.25f + h, light);
            WeatherVertex.put(ptr += 28L, (float)((double)o - cameraX + d + 0.5), (float)((double)s - cameraY), (float)((double)n - cameraZ + e + 0.5), color, 1.0f, (float)r * 0.25f + h, light);
            WeatherVertex.put(ptr += 28L, (float)((double)o - cameraX + d + 0.5), (float)((double)r - cameraY), (float)((double)n - cameraZ + e + 0.5), color, 1.0f, (float)s * 0.25f + h, light);
            WeatherVertex.put(ptr += 28L, (float)((double)o - cameraX - d + 0.5), (float)((double)r - cameraY), (float)((double)n - cameraZ - e + 0.5), color, 0.0f, (float)s * 0.25f + h, light);
            ptr += 28L;
            writer.push(stack, buffer, 4, WeatherVertex.FORMAT);
        }
    }

    private static /* synthetic */ Biome lambda$sodiumExtra$renderWeather$0(Level world, BlockPos.MutableBlockPos mutable, long key) {
        return (Biome)world.m_204166_((BlockPos)mutable).m_203334_();
    }
}

