/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.forge.core.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.event.config.ModConfigEvent;

public class MeadowForgeConfig {
    public static final ForgeConfigSpec COMMON_CONFIG;
    public static final ForgeConfigSpec.BooleanValue GIVE_EFFECT;
    public static final ForgeConfigSpec.BooleanValue SHOW_TOOLTIP;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading e) {
        IConfigSpec iConfigSpec = e.getConfig().getSpec();
        if (iConfigSpec instanceof ForgeConfigSpec) {
            ForgeConfigSpec s = (ForgeConfigSpec)iConfigSpec;
            MeadowForgeConfig.loadConfig(s, e.getConfig().getFileName());
        }
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading e) {
        IConfigSpec iConfigSpec = e.getConfig().getSpec();
        if (iConfigSpec instanceof ForgeConfigSpec) {
            ForgeConfigSpec s = (ForgeConfigSpec)iConfigSpec;
            MeadowForgeConfig.loadConfig(s, e.getConfig().getFileName());
        }
    }

    public static void loadConfig(ForgeConfigSpec s, String p) {
        CommentedFileConfig f = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(p)).sync().preserveInsertionOrder().autosave().writingMode(WritingMode.REPLACE).build();
        f.load();
        s.setConfig((CommentedConfig)f);
    }

    static {
        ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
        COMMON_BUILDER.push("Blocks");
        COMMON_BUILDER.push("Banner");
        GIVE_EFFECT = COMMON_BUILDER.comment("Set to false to disable the banner's effect.").define("giveEffect", true);
        SHOW_TOOLTIP = COMMON_BUILDER.comment("Set to false to hide the banner's tooltip. If giveEffect is false, showTooltip is automatically false.").define("showTooltip", true);
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }
}

