/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.entity;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import net.satisfy.meadow.core.registry.TagRegistry;
import org.jetbrains.annotations.NotNull;

public enum WoolyCowVar implements StringRepresentable
{
    HIGHLAND(0, "highland_cattle", ((Block)ObjectRegistry.HIGHLAND_WOOL.get()).m_5456_(), (Item)ObjectRegistry.WOODEN_MILK_BUCKET.get()),
    UMBRA(1, "umbra_cow", ((Block)ObjectRegistry.UMBRA_WOOL.get()).m_5456_(), (Item)ObjectRegistry.WOODEN_MILK_BUCKET.get()),
    WARPED(2, "warped_cow", ((Block)ObjectRegistry.WARPED_WOOL.get()).m_5456_(), (Item)ObjectRegistry.WOODEN_WARPED_MILK_BUCKET.get());

    public static final Codec<WoolyCowVar> CODEC;
    private static final IntFunction<WoolyCowVar> BY_ID;
    private final int id;
    private final String name;
    private final Item wool;
    private final Item bucket;
    private static final Map<WoolyCowVar, TagKey<Biome>> SPAWNS;

    private WoolyCowVar(int id, String name, Item wool, Item bucket) {
        this.id = id;
        this.name = name;
        this.wool = wool;
        this.bucket = bucket;
    }

    public Item getWool() {
        return this.wool;
    }

    public Item getBucket() {
        return this.bucket;
    }

    public int getId() {
        return this.id;
    }

    public static WoolyCowVar byId(int i) {
        return BY_ID.apply(i);
    }

    @NotNull
    public String m_7912_() {
        return this.name;
    }

    public static WoolyCowVar getRandomVariant(LevelAccessor levelAccessor, BlockPos blockPos, boolean spawnEgg) {
        Holder holder = levelAccessor.m_204166_(blockPos);
        RandomSource random = levelAccessor.m_213780_();
        List<WoolyCowVar> possibleVars = WoolyCowVar.getShearableCowVariantsInBiome((Holder<Biome>)holder);
        int size = possibleVars.size();
        if (size == 0 || spawnEgg) {
            if (spawnEgg) {
                return (WoolyCowVar)((Object)Util.m_214670_((Object[])WoolyCowVar.values(), (RandomSource)random));
            }
            if (holder.m_203656_(BiomeTags.f_207612_)) {
                return WARPED;
            }
            ArrayList<WoolyCowVar> list = new ArrayList<WoolyCowVar>(List.of(WoolyCowVar.values()));
            list.remove((Object)WARPED);
            return (WoolyCowVar)((Object)Util.m_214621_(list, (RandomSource)random));
        }
        return possibleVars.get(levelAccessor.m_213780_().m_188503_(size));
    }

    private static List<WoolyCowVar> getShearableCowVariantsInBiome(Holder<Biome> biome) {
        return SPAWNS.keySet().stream().filter(ShearableCowVariant -> biome.m_203656_(SPAWNS.get(ShearableCowVariant))).collect(Collectors.toList());
    }

    static {
        CODEC = StringRepresentable.m_216439_(WoolyCowVar::values);
        BY_ID = ByIdMap.m_262839_(WoolyCowVar::getId, (Object[])WoolyCowVar.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        SPAWNS = (Map)Util.m_137469_(new HashMap(), map -> {
            map.put(HIGHLAND, TagRegistry.IS_MEADOW);
            map.put(UMBRA, TagRegistry.SPAWNS_UMBRA_COW);
            map.put(WARPED, TagRegistry.SPAWNS_WARPED_COW);
        });
    }
}

