/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v1;

import com.google.common.base.Preconditions;
import fuzs.puzzleslib.api.item.v2.LegacySmithingTransformRecipe;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.data.event.GatherDataEvent;

public abstract class AbstractRecipeProvider
extends RecipeProvider {
    public AbstractRecipeProvider(GatherDataEvent evt, String modId) {
        this(evt.getGenerator().getPackOutput());
    }

    public AbstractRecipeProvider(PackOutput packOutput) {
        super(packOutput);
    }

    protected abstract void m_245200_(Consumer<FinishedRecipe> var1);

    protected static void legacyNetheriteSmithing(String modId, Consumer<FinishedRecipe> exporter, Item base, RecipeCategory category, Item result) {
        AbstractRecipeProvider.legacyNetheriteSmithing(modId, exporter, base, Items.f_42418_, category, result);
    }

    protected static void legacyNetheriteSmithing(String modId, Consumer<FinishedRecipe> exporter, Item base, Item addition, RecipeCategory category, Item result) {
        new SmithingTransformRecipeBuilder(LegacySmithingTransformRecipe.getModSerializer(modId), Ingredient.m_151265_(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{base}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{addition}), category, result).m_266439_(AbstractRecipeProvider.m_176602_((ItemLike)addition), (CriterionTriggerInstance)AbstractRecipeProvider.m_125977_((ItemLike)addition)).m_266371_(exporter, new ResourceLocation(modId, AbstractRecipeProvider.m_176632_((ItemLike)result) + "_smithing_transform"));
    }

    protected static String getHasName(ItemLike ... items) {
        Preconditions.checkPositionIndex((int)0, (int)(items.length - 1), (String)"items is empty");
        return "has_" + Stream.of(items).map(x$0 -> RecipeProvider.m_176632_((ItemLike)x$0)).collect(Collectors.joining("_and_"));
    }

    protected static InventoryChangeTrigger.TriggerInstance has(ItemLike ... items) {
        Preconditions.checkPositionIndex((int)0, (int)(items.length - 1), (String)"items is empty");
        return AbstractRecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(items).m_45077_()});
    }
}

