/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.core.v1;

import fuzs.puzzleslib.impl.PuzzlesLib;
import java.util.Optional;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;

public final class ModContainerHelper {
    private ModContainerHelper() {
    }

    public static Optional<IEventBus> findModEventBus(String modId) {
        ModContainer modContainer = ModContainerHelper.findModContainer(modId);
        if (modContainer instanceof FMLModContainer) {
            FMLModContainer modContainer2 = (FMLModContainer)modContainer;
            return Optional.of(modContainer2.getEventBus());
        }
        PuzzlesLib.LOGGER.error("No mod event bus for id %s exists, cannot proceed mod loading".formatted(modId));
        return Optional.empty();
    }

    public static ModContainer findModContainer(String modId) {
        return (ModContainer)ModList.get().getModContainerById(modId).orElseThrow(() -> new IllegalArgumentException(String.format("No mod container for id %s exists", modId)));
    }
}

