/*
 * Decompiled with CFR 0.152.
 */
package com.boyonk.repoheads.client.gui.screen.widget;

import com.boyonk.repoheads.client.RepoDrawContextHelper;
import com.boyonk.repoheads.client.gui.screen.widget.TickableElement;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class MouthWidget
extends AbstractWidget
implements TickableElement {
    private static final ResourceLocation TEXTURE = ResourceLocation.m_214293_((String)"repo-heads", (String)"textures/gui/sprites/widget/mouth.png");
    private static final int DISTANCE = 4;
    private static final int INTERPOLATION_TICKS = 3;
    private boolean dragging = false;
    private boolean shake = false;
    private final int areaHeight;
    private int min;
    private int value;
    private final ChangeAction action;
    private int interpolationTicks = 0;
    private int prevRenderY;
    private int renderY;

    public MouthWidget(MouthWidget previous, int x, int y, int width, int height, int areaHeight, ChangeAction action) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.areaHeight = areaHeight;
        this.min = previous == null ? 0 : previous.min;
        this.value = previous == null ? 1 : previous.value;
        this.action = action;
        this.updateRenderY();
        this.updatePrevRenderY();
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.dragging = true;
        this.updateValueFromMouse(mouseX, mouseY);
    }

    protected void m_7212_(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (!this.dragging) {
            return;
        }
        this.updateValueFromMouse(mouseX, mouseY);
    }

    public void m_7691_(double mouseX, double mouseY) {
        this.dragging = false;
        this.shake = false;
    }

    private void updateValueFromMouse(double mouseX, double mouseY) {
        int value = (int)Math.round((mouseY - (double)this.m_252907_()) / (double)this.m_93694_() * (double)this.areaHeight);
        if ((value = Mth.m_14045_((int)value, (int)0, (int)this.areaHeight)) < this.min) {
            value = this.min;
            this.shake = true;
        } else {
            this.shake = false;
        }
        if (value != this.value) {
            this.value = value;
            this.action.onChange(this, this.value);
        }
    }

    public void m_87963_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        float smoothY = Mth.m_269140_((float)(delta = ((float)this.interpolationTicks + delta) / 3.0f), (int)this.prevRenderY, (int)this.renderY);
        int y = (int)smoothY;
        this.f_93622_ = Math.abs(mouseY - y) < 4 || this.dragging;
        int x1 = this.m_252754_() - 2;
        int y1 = y - 2;
        int x2 = this.m_252754_() + this.m_5711_() + 2;
        int y2 = y + 2;
        float xShake = 0.0f;
        float yShake = 0.0f;
        if (this.dragging && this.shake) {
            xShake = Mth.m_14031_((float)delta);
        }
        context.m_280168_().m_85836_();
        context.m_280168_().m_252880_(xShake, smoothY - (float)y + yShake, 2.0f);
        RepoDrawContextHelper.drawColoredNineSlicedTexture(context, TEXTURE, x1, y1, x2 - x1, y2 - y1, 2, 20, 20, 0, 0, 20, 20, 20, 20, -1);
        context.m_280262_();
        context.m_280168_().m_85849_();
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        int y = this.m_252907_() + this.value * (this.m_93694_() / this.areaHeight);
        return Math.abs(mouseY - (double)y) < 4.0;
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        return this.m_5953_(mouseX, mouseY);
    }

    protected void m_168797_(NarrationElementOutput builder) {
    }

    public void setValueNoCallback(int value) {
        this.value = Mth.m_14045_((int)value, (int)0, (int)this.areaHeight);
        this.updateRenderY();
        this.updatePrevRenderY();
    }

    public void setMin(int min) {
        this.min = Mth.m_14045_((int)min, (int)0, (int)this.areaHeight);
        if (this.value < this.min) {
            this.value = this.min;
            this.action.onChange(this, this.value);
        }
    }

    @Override
    public void tick() {
        if (++this.interpolationTicks >= 3) {
            this.interpolationTicks = 0;
            this.updatePrevRenderY();
            this.updateRenderY();
        }
    }

    public void updatePrevRenderY() {
        this.prevRenderY = this.renderY;
    }

    public void updateRenderY() {
        this.renderY = this.m_252907_() + this.value * (this.m_93694_() / this.areaHeight);
    }

    @FunctionalInterface
    public static interface ChangeAction {
        public void onChange(MouthWidget var1, int var2);
    }
}

