/*
 * Decompiled with CFR 0.152.
 */
package com.boyonk.repoheads.client.gui.screen.widget;

import com.boyonk.repoheads.client.Box2i;
import com.boyonk.repoheads.client.RepoDrawContextHelper;
import com.boyonk.repoheads.client.gui.screen.widget.RoundingType;
import com.boyonk.repoheads.client.gui.screen.widget.TickableElement;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class EyeAreaWidget
extends AbstractWidget
implements TickableElement {
    private static final ResourceLocation PUPIL_OUTLINE = ResourceLocation.m_214293_((String)"repo-heads", (String)"textures/gui/sprites/widget/pupil_outline.png");
    private static final ResourceLocation SCLERA_OUTLINE = ResourceLocation.m_214293_((String)"repo-heads", (String)"textures/gui/sprites/widget/sclera_outline.png");
    private static final ResourceLocation PUPIL_FILL = ResourceLocation.m_214293_((String)"repo-heads", (String)"textures/gui/sprites/widget/pupil_fill.png");
    private static final ResourceLocation SCLERA_FILL = ResourceLocation.m_214293_((String)"repo-heads", (String)"textures/gui/sprites/widget/sclera_fill.png");
    private static final ResourceLocation LEFT_HIGHLIGHT = ResourceLocation.m_214293_((String)"repo-heads", (String)"textures/gui/sprites/widget/left_highlight.png");
    private static final ResourceLocation RIGHT_HIGHLIGHT = ResourceLocation.m_214293_((String)"repo-heads", (String)"textures/gui/sprites/widget/right_highlight.png");
    private static final int FILL_INTERPOLATION_TICKS = 20;
    private static final int ADD_BUTTON = 0;
    private static final int REMOVE_BUTTON = 1;
    private static final int INVALID_BUTTON = -1;
    private static final int EMPTY = 0;
    private static final int SCLERA = 1;
    private static final int PUPIL = 2;
    private static final int INVALID_TYPE = -1;
    int activeButton = -1;
    int dragging = -1;
    private final byte[] area;
    private final int areaWidth;
    private final int areaHeight;
    private final boolean left;
    @Nullable
    private Box2i.Mutable pupil;
    @Nullable
    private Box2i.Mutable sclera;
    private int prevPupilRenderMinX = -1;
    private int prevPupilRenderMinY = -1;
    private int prevPupilRenderMaxX = -1;
    private int prevPupilRenderMaxY = -1;
    private int prevScleraRenderMinX = -1;
    private int prevScleraRenderMinY = -1;
    private int prevScleraRenderMaxX = -1;
    private int prevScleraRenderMaxY = -1;
    private int pupilRenderMinX = -1;
    private int pupilRenderMinY = -1;
    private int pupilRenderMaxX = -1;
    private int pupilRenderMaxY = -1;
    private int scleraRenderMinX = -1;
    private int scleraRenderMinY = -1;
    private int scleraRenderMaxX = -1;
    private int scleraRenderMaxY = -1;
    private final byte[] prevPupilRenderArea;
    private final byte[] prevScleraRenderArea;
    private final byte[] pupilRenderArea;
    private final byte[] scleraRenderArea;
    private final ChangeAction action;
    private boolean showHighlight = true;

    public EyeAreaWidget(@Nullable EyeAreaWidget previous, int x, int y, int width, int height, int areaWidth, int areaHeight, boolean left, ChangeAction action) {
        super(x, y, width, height, (Component)Component.m_237119_());
        int areaSize = areaWidth * areaHeight;
        this.area = new byte[areaSize];
        this.areaWidth = areaWidth;
        this.areaHeight = areaHeight;
        this.left = left;
        this.action = action;
        this.prevPupilRenderArea = new byte[areaSize];
        this.prevScleraRenderArea = new byte[areaSize];
        this.pupilRenderArea = new byte[areaSize];
        this.scleraRenderArea = new byte[areaSize];
        if (previous != null) {
            this.updateFromPrevious(previous);
        }
        this.updateRenderRegions();
        this.updatePrevRenderRegions();
    }

    private void updateFromPrevious(EyeAreaWidget previous) {
        this.sclera = previous.sclera;
        this.pupil = previous.pupil;
        for (int x = 0; x < this.areaWidth; ++x) {
            for (int y = 0; y < this.areaHeight; ++y) {
                if (this.pupil != null && x >= this.pupil.minX() && x <= this.pupil.maxX() && y >= this.pupil.minY() && y <= this.pupil.maxY()) {
                    this.setUnchecked(x, y, 2);
                    continue;
                }
                if (this.sclera == null || x < this.sclera.minX() || x > this.sclera.maxX() || y < this.sclera.minY() || y > this.sclera.maxY()) continue;
                this.setUnchecked(x, y, 1);
            }
        }
    }

    private void onClick(int areaX, int areaY, int button) {
        if (!this.isValidArea(areaX, areaY)) {
            return;
        }
        if (button == -1) {
            return;
        }
        if (button == 0) {
            int previous = this.getUnchecked(areaX, areaY);
            if (previous == 0) {
                this.setUnchecked(areaX, areaY, 1);
                this.onAddedSclera(areaX, areaY);
                this.scleraRenderArea[this.index((int)areaX, (int)areaY)] = 20;
                this.dragging = 1;
            } else if (previous == 1) {
                this.setUnchecked(areaX, areaY, 2);
                this.onAddedPupil(areaX, areaY);
                this.pupilRenderArea[this.index((int)areaX, (int)areaY)] = 20;
                this.dragging = 2;
            }
        } else if (button == 1) {
            int previous = this.getUnchecked(areaX, areaY);
            if (previous == 1) {
                this.setUnchecked(areaX, areaY, 0);
                this.onRemovedSclera(areaX, areaY);
                this.scleraRenderArea[this.index((int)areaX, (int)areaY)] = 0;
                this.dragging = 0;
            } else if (previous == 2) {
                this.setUnchecked(areaX, areaY, 1);
                this.onRemovedPupil(areaX, areaY);
                this.pupilRenderArea[this.index((int)areaX, (int)areaY)] = 0;
                this.dragging = 1;
            }
        }
        this.action.onChange(this, this.sclera, this.pupil);
    }

    private void onDrag(int areaX, int areaY, int type) {
        if (!this.isValidArea(areaX, areaY)) {
            return;
        }
        int previous = this.getUnchecked(areaX, areaY);
        if (previous == type) {
            return;
        }
        if (previous < type) {
            if (type == 1) {
                this.setUnchecked(areaX, areaY, 1);
                this.onAddedSclera(areaX, areaY);
            } else if (type == 2) {
                if (previous == 0) {
                    this.setUnchecked(areaX, areaY, 1);
                    this.onAddedSclera(areaX, areaY);
                }
                this.setUnchecked(areaX, areaY, 2);
                this.onAddedPupil(areaX, areaY);
            }
        } else if (type == 1) {
            this.setUnchecked(areaX, areaY, 1);
            this.onRemovedPupil(areaX, areaY);
        } else if (type == 0) {
            if (previous == 2) {
                this.setUnchecked(areaX, areaY, 1);
                this.onRemovedPupil(areaX, areaY);
            }
            this.setUnchecked(areaX, areaY, 0);
            this.onRemovedSclera(areaX, areaY);
        }
    }

    private void onAddedPupil(int areaX, int areaY) {
        if (this.pupil == null) {
            this.pupil = Box2i.mutable(areaX, areaY, areaX, areaY);
            return;
        }
        if (areaX < this.pupil.minX()) {
            for (y = this.pupil.minY(); y <= this.pupil.maxY(); ++y) {
                for (x = areaX; x < this.pupil.minX(); ++x) {
                    this.setUnchecked(x, y, 2);
                }
            }
            this.pupil.minX(areaX);
        } else if (areaX > this.pupil.maxX()) {
            for (y = this.pupil.minY(); y <= this.pupil.maxY(); ++y) {
                for (x = this.pupil.maxX(); x <= areaX; ++x) {
                    this.setUnchecked(x, y, 2);
                }
            }
            this.pupil.maxX(areaX);
        }
        if (areaY < this.pupil.minY()) {
            for (x = this.pupil.minX(); x <= this.pupil.maxX(); ++x) {
                for (y = areaY; y < this.pupil.minY(); ++y) {
                    this.setUnchecked(x, y, 2);
                }
            }
            this.pupil.minY(areaY);
        } else if (areaY > this.pupil.maxY()) {
            for (x = this.pupil.minX(); x <= this.pupil.maxX(); ++x) {
                for (y = this.pupil.maxY(); y <= areaY; ++y) {
                    this.setUnchecked(x, y, 2);
                }
            }
            this.pupil.maxY(areaY);
        }
    }

    private void onAddedSclera(int areaX, int areaY) {
        if (this.sclera == null) {
            this.sclera = Box2i.mutable(areaX, areaY, areaX, areaY);
            return;
        }
        if (areaX < this.sclera.minX()) {
            for (y = this.sclera.minY(); y <= this.sclera.maxY(); ++y) {
                for (x = areaX; x < this.sclera.minX(); ++x) {
                    if (this.getUnchecked(x, y) == 2) continue;
                    this.setUnchecked(x, y, 1);
                }
            }
            this.sclera.minX(areaX);
        } else if (areaX > this.sclera.maxX()) {
            for (y = this.sclera.minY(); y <= this.sclera.maxY(); ++y) {
                for (x = this.sclera.maxX(); x <= areaX; ++x) {
                    if (this.getUnchecked(x, y) == 2) continue;
                    this.setUnchecked(x, y, 1);
                }
            }
            this.sclera.maxX(areaX);
        }
        if (areaY < this.sclera.minY()) {
            for (x = this.sclera.minX(); x <= this.sclera.maxX(); ++x) {
                for (y = areaY; y < this.sclera.minY(); ++y) {
                    if (this.getUnchecked(x, y) == 2) continue;
                    this.setUnchecked(x, y, 1);
                }
            }
            this.sclera.minY(areaY);
        } else if (areaY > this.sclera.maxY()) {
            for (x = this.sclera.minX(); x <= this.sclera.maxX(); ++x) {
                for (y = this.sclera.maxY(); y <= areaY; ++y) {
                    if (this.getUnchecked(x, y) == 2) continue;
                    this.setUnchecked(x, y, 1);
                }
            }
            this.sclera.maxY(areaY);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onRemovedPupil(int areaX, int areaY) {
        int x;
        int y;
        boolean removeY;
        float centerY;
        block22: {
            int y2;
            int x2;
            block25: {
                block24: {
                    float centerX;
                    block23: {
                        boolean removeX;
                        if (this.pupil == null) {
                            return;
                        }
                        centerX = (float)(this.pupil.minX() + this.pupil.maxX()) / 2.0f;
                        centerY = (float)(this.pupil.minY() + this.pupil.maxY()) / 2.0f;
                        if ((float)areaX == centerX && (float)areaY == centerY) {
                            this.clearPupil();
                            return;
                        }
                        if ((float)areaY == centerY) {
                            removeX = true;
                            removeY = false;
                        } else if ((float)areaX == centerX) {
                            removeX = false;
                            removeY = true;
                        } else {
                            int yDepth;
                            int xDepth = Math.min(this.pupil.maxX() - areaX, areaX - this.pupil.minX());
                            if (xDepth == (yDepth = Math.min(this.pupil.maxY() - areaY, areaY - this.pupil.minY()))) {
                                int yLength;
                                int xLength = this.pupil.maxX() - this.pupil.minX();
                                removeX = xLength >= (yLength = this.pupil.maxY() - this.pupil.minY());
                                removeY = yLength >= xLength;
                            } else {
                                removeX = xDepth <= yDepth;
                                boolean bl = removeY = yDepth <= xDepth;
                            }
                        }
                        if (!removeX) break block22;
                        if (!((float)areaX > centerX)) break block23;
                        break block24;
                    }
                    if (!((float)areaX < centerX)) break block22;
                    break block25;
                }
                for (x2 = areaX; x2 <= this.pupil.maxX(); ++x2) {
                    for (y2 = this.pupil.minY(); y2 <= this.pupil.maxY(); ++y2) {
                        this.setUnchecked(x2, y2, 1);
                    }
                }
                if (this.pupil.minX() >= areaX) {
                    this.clearPupil();
                    return;
                }
                this.pupil.maxX(areaX - 1);
                break block22;
            }
            for (x2 = this.pupil.minX(); x2 <= areaX; ++x2) {
                for (y2 = this.pupil.minY(); y2 <= this.pupil.maxY(); ++y2) {
                    this.setUnchecked(x2, y2, 1);
                }
            }
            if (this.pupil.maxX() <= areaX) {
                this.clearPupil();
                return;
            }
            this.pupil.minX(areaX + 1);
        }
        if (!removeY) return;
        if (!((float)areaY > centerY)) {
            if (!((float)areaY < centerY)) return;
        } else {
            for (y = areaY; y <= this.pupil.maxY(); ++y) {
                for (x = this.pupil.minX(); x <= this.pupil.maxX(); ++x) {
                    this.setUnchecked(x, y, 1);
                }
            }
            if (this.pupil.minY() < areaY) {
                this.pupil.maxY(areaY - 1);
                return;
            }
            this.clearPupil();
            return;
        }
        for (y = this.pupil.minY(); y <= areaY; ++y) {
            for (x = this.pupil.minX(); x <= this.pupil.maxX(); ++x) {
                this.setUnchecked(x, y, 1);
            }
        }
        if (this.pupil.maxY() > areaY) {
            this.pupil.minY(areaY + 1);
            return;
        }
        this.clearPupil();
    }

    private void clearPupil() {
        if (this.pupil == null) {
            return;
        }
        for (int x = this.pupil.minX(); x <= this.pupil.maxX(); ++x) {
            for (int y = this.pupil.minY(); y <= this.pupil.maxY(); ++y) {
                this.setUnchecked(x, y, 1);
            }
        }
        this.pupil = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onRemovedSclera(int areaX, int areaY) {
        int x;
        int y;
        boolean removeY;
        float centerY;
        block26: {
            int y2;
            int x2;
            block29: {
                block28: {
                    float centerX;
                    block27: {
                        boolean removeX;
                        if (this.sclera == null) {
                            return;
                        }
                        centerX = (float)(this.sclera.minX() + this.sclera.maxX()) / 2.0f;
                        centerY = (float)(this.sclera.minY() + this.sclera.maxY()) / 2.0f;
                        if ((float)areaX == centerX && (float)areaY == centerY) {
                            this.clearSclera();
                            return;
                        }
                        if ((float)areaY == centerY) {
                            removeX = true;
                            removeY = false;
                        } else if ((float)areaX == centerX) {
                            removeX = false;
                            removeY = true;
                        } else {
                            int yDepth;
                            int xDepth = Math.min(this.sclera.maxX() - areaX, areaX - this.sclera.minX());
                            if (xDepth == (yDepth = Math.min(this.sclera.maxY() - areaY, areaY - this.sclera.minY()))) {
                                int yLength;
                                int xLength = this.sclera.maxX() - this.sclera.minX();
                                removeX = xLength >= (yLength = this.sclera.maxY() - this.sclera.minY());
                                removeY = yLength >= xLength;
                            } else {
                                removeX = xDepth <= yDepth;
                                boolean bl = removeY = yDepth <= xDepth;
                            }
                        }
                        if (!removeX) break block26;
                        if (!((float)areaX > centerX)) break block27;
                        break block28;
                    }
                    if (!((float)areaX < centerX)) break block26;
                    break block29;
                }
                for (x2 = areaX; x2 <= this.sclera.maxX(); ++x2) {
                    for (y2 = this.sclera.minY(); y2 <= this.sclera.maxY(); ++y2) {
                        if (this.getUnchecked(x2, y2) == 2) {
                            this.onRemovedPupil(x2, y2);
                        }
                        this.setUnchecked(x2, y2, 0);
                    }
                }
                if (this.sclera.minX() >= areaX) {
                    this.clearSclera();
                    return;
                }
                this.sclera.maxX(areaX - 1);
                break block26;
            }
            for (x2 = this.sclera.minX(); x2 <= areaX; ++x2) {
                for (y2 = this.sclera.minY(); y2 <= this.sclera.maxY(); ++y2) {
                    if (this.getUnchecked(x2, y2) == 2) {
                        this.onRemovedPupil(x2, y2);
                    }
                    this.setUnchecked(x2, y2, 0);
                }
            }
            if (this.sclera.maxX() <= areaX) {
                this.clearSclera();
                return;
            }
            this.sclera.minX(areaX + 1);
        }
        if (!removeY) return;
        if (!((float)areaY > centerY)) {
            if (!((float)areaY < centerY)) return;
        } else {
            for (y = areaY; y <= this.sclera.maxY(); ++y) {
                for (x = this.sclera.minX(); x <= this.sclera.maxX(); ++x) {
                    if (this.getUnchecked(x, y) == 2) {
                        this.onRemovedPupil(x, y);
                    }
                    this.setUnchecked(x, y, 0);
                }
            }
            if (this.sclera.minY() < areaY) {
                this.sclera.maxY(areaY - 1);
                return;
            }
            this.clearSclera();
            return;
        }
        for (y = this.sclera.minY(); y <= areaY; ++y) {
            for (x = this.sclera.minX(); x <= this.sclera.maxX(); ++x) {
                if (this.getUnchecked(x, y) == 2) {
                    this.onRemovedPupil(x, y);
                }
                this.setUnchecked(x, y, 0);
            }
        }
        if (this.sclera.maxY() > areaY) {
            this.sclera.minY(areaY + 1);
            return;
        }
        this.clearSclera();
    }

    private void clearSclera() {
        if (this.sclera == null) {
            return;
        }
        this.clearPupil();
        for (int x = this.sclera.minX(); x <= this.sclera.maxX(); ++x) {
            for (int y = this.sclera.minY(); y <= this.sclera.maxY(); ++y) {
                this.setUnchecked(x, y, 0);
            }
        }
        this.sclera = null;
    }

    private void setUnchecked(int areaX, int areaY, int value) {
        int index = this.index(areaX, areaY);
        this.area[index] = (byte)value;
    }

    private int getUnchecked(int areaX, int areaY) {
        int index = this.index(areaX, areaY);
        return this.area[index];
    }

    private int index(int areaX, int areaY) {
        return areaX + areaY * this.areaWidth;
    }

    private int getAreaX(double mouseX) {
        return Mth.m_14107_((double)((mouseX - (double)this.m_252754_()) / (double)this.m_5711_() * (double)this.areaWidth));
    }

    private int getAreaY(double mouseY) {
        return Mth.m_14107_((double)((mouseY - (double)this.m_252907_()) / (double)this.m_93694_() * (double)this.areaHeight));
    }

    private double getMouseX(int areaX, RoundingType type) {
        double resolution = (double)this.m_5711_() / (double)this.areaWidth;
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case RoundingType.ROUND -> (double)this.m_252754_() + (double)areaX * resolution + resolution * 0.5;
            case RoundingType.FLOOR -> (double)this.m_252754_() + (double)areaX * resolution;
            case RoundingType.CEIL -> (double)this.m_252754_() + (double)areaX * resolution + resolution;
        };
    }

    private double getMouseY(int areaY, RoundingType type) {
        double resolution = (double)this.m_93694_() / (double)this.areaHeight;
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case RoundingType.ROUND -> (double)this.m_252907_() + (double)areaY * resolution + resolution * 0.5;
            case RoundingType.FLOOR -> (double)this.m_252907_() + (double)areaY * resolution;
            case RoundingType.CEIL -> (double)this.m_252907_() + (double)areaY * resolution + resolution;
        };
    }

    private boolean isValidArea(int x, int y) {
        return x >= 0 && x < this.areaWidth && y >= 0 && y < this.areaHeight;
    }

    @Override
    public void tick() {
        this.updatePrevRenderRegions();
        this.updateRenderRegions();
    }

    private void updatePrevRenderRegions() {
        System.arraycopy(this.pupilRenderArea, 0, this.prevPupilRenderArea, 0, this.pupilRenderArea.length);
        System.arraycopy(this.scleraRenderArea, 0, this.prevScleraRenderArea, 0, this.scleraRenderArea.length);
        this.prevPupilRenderMinX = this.pupilRenderMinX;
        this.prevPupilRenderMinY = this.pupilRenderMinY;
        this.prevPupilRenderMaxX = this.pupilRenderMaxX;
        this.prevPupilRenderMaxY = this.pupilRenderMaxY;
        this.prevScleraRenderMinX = this.scleraRenderMinX;
        this.prevScleraRenderMinY = this.scleraRenderMinY;
        this.prevScleraRenderMaxX = this.scleraRenderMaxX;
        this.prevScleraRenderMaxY = this.scleraRenderMaxY;
    }

    private void updateRenderRegions() {
        for (int index = 0; index < this.area.length; ++index) {
            byte value = this.area[index];
            byte pupil = this.pupilRenderArea[index];
            byte sclera = this.scleraRenderArea[index];
            if (value == 2) {
                if (pupil < 20) {
                    int n = index;
                    this.pupilRenderArea[n] = (byte)(this.pupilRenderArea[n] + 1);
                }
            } else if (pupil > 0) {
                int n = index;
                this.pupilRenderArea[n] = (byte)(this.pupilRenderArea[n] - 1);
            }
            if (value == 1) {
                if (sclera >= 20) continue;
                int n = index;
                this.scleraRenderArea[n] = (byte)(this.scleraRenderArea[n] + 1);
                continue;
            }
            if (sclera <= 0) continue;
            int n = index;
            this.scleraRenderArea[n] = (byte)(this.scleraRenderArea[n] - 1);
        }
        if (this.pupil == null) {
            this.pupilRenderMinX = -1;
            this.pupilRenderMinY = -1;
            this.pupilRenderMaxX = -1;
            this.pupilRenderMaxY = -1;
        } else {
            this.pupilRenderMinX = (int)this.getMouseX(this.pupil.minX(), RoundingType.FLOOR);
            this.pupilRenderMinY = (int)this.getMouseY(this.pupil.minY(), RoundingType.FLOOR);
            this.pupilRenderMaxX = (int)this.getMouseX(this.pupil.maxX(), RoundingType.CEIL);
            this.pupilRenderMaxY = (int)this.getMouseY(this.pupil.maxY(), RoundingType.CEIL);
        }
        if (this.sclera == null) {
            this.scleraRenderMinX = -1;
            this.scleraRenderMinY = -1;
            this.scleraRenderMaxX = -1;
            this.scleraRenderMaxY = -1;
        } else {
            this.scleraRenderMinX = (int)this.getMouseX(this.sclera.minX(), RoundingType.FLOOR) - 2;
            this.scleraRenderMinY = (int)this.getMouseY(this.sclera.minY(), RoundingType.FLOOR) - 2;
            this.scleraRenderMaxX = (int)this.getMouseX(this.sclera.maxX(), RoundingType.CEIL) + 2;
            this.scleraRenderMaxY = (int)this.getMouseY(this.sclera.maxY(), RoundingType.CEIL) + 2;
        }
    }

    public void setShowHighlight(boolean showHighlight) {
        this.showHighlight = showHighlight;
    }

    public void m_87963_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int highlightY;
        int highlightX;
        context.m_280168_().m_85836_();
        context.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
        RenderSystem.enableBlend();
        this.renderSclera(context, delta);
        this.renderPupil(context, delta);
        if (this.showHighlight && this.isValidArea(highlightX = this.getAreaX(mouseX), highlightY = this.getAreaY(mouseY))) {
            int minX = (int)this.getMouseX(highlightX, RoundingType.FLOOR);
            int minY = (int)this.getMouseY(highlightY, RoundingType.FLOOR);
            int maxX = (int)this.getMouseX(highlightX, RoundingType.CEIL);
            int maxY = (int)this.getMouseY(highlightY, RoundingType.CEIL);
            RepoDrawContextHelper.drawColoredRepeatingTexture(context, this.left ? LEFT_HIGHLIGHT : RIGHT_HIGHLIGHT, minX, minY, maxX - minX, maxY - minY, 0, 0, 16, 16, 16, 16, -1);
        }
        context.m_280262_();
        RenderSystem.disableBlend();
        context.m_280168_().m_85849_();
    }

    protected void renderSclera(GuiGraphics context, float delta) {
        if (this.prevScleraRenderMinX != -1 || this.scleraRenderMinX != -1) {
            if (this.prevScleraRenderMinX == -1 || this.scleraRenderMinX == -1) {
                boolean fadeIn = this.prevScleraRenderMinX == -1;
                RepoDrawContextHelper.drawColoredNineSlicedTexture(context, SCLERA_OUTLINE, this.prevScleraRenderMinX, this.prevScleraRenderMinY, this.prevScleraRenderMaxX - this.prevScleraRenderMinX, this.prevScleraRenderMaxY - this.prevScleraRenderMinY, 2, 20, 20, 0, 0, 20, 20, 20, 20, FastColor.ARGB32.m_13660_((int)(fadeIn ? Math.round(delta * 255.0f) : Math.round((1.0f - delta) * 255.0f)), (int)255, (int)255, (int)255));
            } else {
                int minX = Mth.m_269140_((float)delta, (int)this.prevScleraRenderMinX, (int)this.scleraRenderMinX);
                int minY = Mth.m_269140_((float)delta, (int)this.prevScleraRenderMinY, (int)this.scleraRenderMinY);
                int maxX = Mth.m_269140_((float)delta, (int)this.prevScleraRenderMaxX, (int)this.scleraRenderMaxX);
                int maxY = Mth.m_269140_((float)delta, (int)this.prevScleraRenderMaxY, (int)this.scleraRenderMaxY);
                RepoDrawContextHelper.drawColoredNineSlicedTexture(context, SCLERA_OUTLINE, minX, minY, maxX - minX, maxY - minY, 2, 20, 20, 0, 0, 20, 20, 20, 20, -1);
            }
        }
        for (int x = 0; x < this.areaWidth; ++x) {
            for (int y = 0; y < this.areaHeight; ++y) {
                int minX = (int)this.getMouseX(x, RoundingType.FLOOR);
                int minY = (int)this.getMouseY(y, RoundingType.FLOOR);
                int maxX = (int)this.getMouseX(x, RoundingType.CEIL);
                int maxY = (int)this.getMouseY(y, RoundingType.CEIL);
                int prevAlpha = this.prevScleraRenderArea[this.index(x, y)] * 12;
                int alpha = this.scleraRenderArea[this.index(x, y)] * 12;
                RepoDrawContextHelper.drawColoredRepeatingTexture(context, SCLERA_FILL, minX, minY, maxX - minX, maxY - minY, 0, 0, 16, 16, 16, 16, FastColor.ARGB32.m_13660_((int)Mth.m_269140_((float)delta, (int)prevAlpha, (int)alpha), (int)255, (int)255, (int)255));
            }
        }
    }

    protected void renderPupil(GuiGraphics context, float delta) {
        if (this.prevPupilRenderMinX != -1 || this.pupilRenderMinX != -1) {
            if (this.prevPupilRenderMinX == -1 || this.pupilRenderMinX == -1) {
                boolean fadeIn = this.prevPupilRenderMinX == -1;
                RepoDrawContextHelper.drawColoredNineSlicedTexture(context, PUPIL_OUTLINE, this.prevPupilRenderMinX, this.prevPupilRenderMinY, this.prevPupilRenderMaxX - this.prevPupilRenderMinX, this.prevPupilRenderMaxY - this.prevPupilRenderMinY, 2, 20, 20, 0, 0, 20, 20, 20, 20, FastColor.ARGB32.m_13660_((int)(fadeIn ? Math.round(delta * 255.0f) : Math.round((1.0f - delta) * 255.0f)), (int)255, (int)255, (int)255));
            } else {
                int minX = Mth.m_269140_((float)delta, (int)this.prevPupilRenderMinX, (int)this.pupilRenderMinX);
                int minY = Mth.m_269140_((float)delta, (int)this.prevPupilRenderMinY, (int)this.pupilRenderMinY);
                int maxX = Mth.m_269140_((float)delta, (int)this.prevPupilRenderMaxX, (int)this.pupilRenderMaxX);
                int maxY = Mth.m_269140_((float)delta, (int)this.prevPupilRenderMaxY, (int)this.pupilRenderMaxY);
                RepoDrawContextHelper.drawColoredNineSlicedTexture(context, PUPIL_OUTLINE, minX, minY, maxX - minX, maxY - minY, 2, 20, 20, 0, 0, 20, 20, 20, 20, -1);
            }
        }
        for (int x = 0; x < this.areaWidth; ++x) {
            for (int y = 0; y < this.areaHeight; ++y) {
                int minX = (int)this.getMouseX(x, RoundingType.FLOOR);
                int minY = (int)this.getMouseY(y, RoundingType.FLOOR);
                int maxX = (int)this.getMouseX(x, RoundingType.CEIL);
                int maxY = (int)this.getMouseY(y, RoundingType.CEIL);
                int prevAlpha = this.prevPupilRenderArea[this.index(x, y)] * 12;
                int alpha = this.pupilRenderArea[this.index(x, y)] * 12;
                RepoDrawContextHelper.drawColoredRepeatingTexture(context, PUPIL_FILL, minX, minY, maxX - minX, maxY - minY, 0, 0, 16, 16, 16, 16, FastColor.ARGB32.m_13660_((int)Mth.m_269140_((float)delta, (int)prevAlpha, (int)alpha), (int)255, (int)255, (int)255));
            }
        }
    }

    public void m_5716_(double mouseX, double mouseY) {
        super.m_5716_(mouseX, mouseY);
        int x = this.getAreaX(mouseX);
        int y = this.getAreaY(mouseY);
        this.onClick(x, y, this.activeButton);
    }

    protected void m_7212_(double mouseX, double mouseY, double deltaX, double deltaY) {
    }

    public void m_7691_(double mouseX, double mouseY) {
        this.activeButton = -1;
        this.dragging = -1;
    }

    protected boolean m_7972_(int button) {
        if (button == 0 || button == 1) {
            this.activeButton = button;
            return true;
        }
        this.activeButton = -1;
        return false;
    }

    protected void m_168797_(NarrationElementOutput builder) {
        this.m_168802_(builder);
    }

    public void setScleraNoCallback(@Nullable Box2i sclera) {
        this.clearSclera();
        if (sclera == null) {
            return;
        }
        this.sclera = sclera.mutable();
        for (int x = this.sclera.minX(); x <= this.sclera.maxX(); ++x) {
            for (int y = this.sclera.minY(); y <= this.sclera.maxY(); ++y) {
                this.setUnchecked(x, y, 1);
            }
        }
        this.updateRenderRegions();
        this.updatePrevRenderRegions();
    }

    public void setPupilNoCallback(@Nullable Box2i pupil) {
        this.clearPupil();
        if (pupil == null) {
            return;
        }
        this.pupil = pupil.mutable();
        for (int x = this.pupil.minX(); x <= this.pupil.maxX(); ++x) {
            for (int y = this.pupil.minY(); y <= this.pupil.maxY(); ++y) {
                this.setUnchecked(x, y, 2);
            }
        }
        this.updateRenderRegions();
        this.updatePrevRenderRegions();
    }

    @FunctionalInterface
    public static interface ChangeAction {
        public void onChange(EyeAreaWidget var1, @Nullable Box2i var2, @Nullable Box2i var3);
    }
}

