/*
 * Decompiled with CFR 0.152.
 */
package com.boyonk.repoheads.client.gui.screen;

import com.boyonk.repoheads.client.Box2i;
import com.boyonk.repoheads.client.RepoData;
import com.boyonk.repoheads.client.RepoHeadsClient;
import com.boyonk.repoheads.client.RepoHeadsClientConfig;
import com.boyonk.repoheads.client.dummy.RepoPlayerListEntry;
import com.boyonk.repoheads.client.gui.screen.widget.EyeAreaWidget;
import com.boyonk.repoheads.client.gui.screen.widget.MouthWidget;
import com.boyonk.repoheads.client.gui.screen.widget.TickableElement;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.voicechat.gui.GameProfileUtils;
import de.maxhenkel.voicechat.gui.VoiceChatScreenBase;
import de.maxhenkel.voicechat.gui.widgets.ImageButton;
import de.maxhenkel.voicechat.gui.widgets.ToggleImageButton;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class RepoHeadsScreen
extends VoiceChatScreenBase {
    private static final Component TITLE = Component.m_237113_((String)"R.E.P.O. Heads");
    private static final ResourceLocation TEXTURE = ResourceLocation.m_214293_((String)"repo-heads", (String)"textures/gui/repo_heads.png");
    private static final ResourceLocation CENTER_PUPIL = ResourceLocation.m_214293_((String)"repo-heads", (String)"textures/gui/center_pupil.png");
    private static final ResourceLocation HIDE_SELF = ResourceLocation.m_214293_((String)"repo-heads", (String)"textures/gui/hide_self.png");
    private static final ResourceLocation HIDE_OTHERS = ResourceLocation.m_214293_((String)"repo-heads", (String)"textures/gui/hide_others.png");
    private static final int RESOLUTION = 16;
    private static final int HEAD_SIZE = 128;
    private static final int HEAD_SIZE_HALF = 64;
    private RepoData data;
    private boolean hideSelf;
    private boolean hideOthers;
    private ToggleImageButton centerPupilWidget;
    private ToggleImageButton hideSelfWidget;
    private ToggleImageButton hideOthersWidget;
    private MouthWidget mouthWidget;
    private EyeAreaWidget leftEyeWidget;
    private EyeAreaWidget rightEyeWidget;

    public RepoHeadsScreen() {
        super(TITLE, 176, 208);
        RepoHeadsClientConfig config = RepoHeadsClient.getConfig();
        this.data = config.data();
        this.hideSelf = config.hideSelf();
        this.hideOthers = config.hideOthers();
    }

    protected void m_7856_() {
        super.m_7856_();
        boolean firstInit = this.mouthWidget == null;
        int headX = this.guiLeft + 24;
        int headY = this.guiTop + 32;
        this.centerPupilWidget = new ToggleImageButton(this.guiLeft + 6, this.guiTop + this.ySize - 6 - 20, CENTER_PUPIL, () -> this.data.centerPupil, this::onCenterPupilPressed, this::onCenterPupilTooltip);
        this.hideSelfWidget = new ToggleImageButton(this.guiLeft + this.xSize - 6 - 20 - 2 - 20, this.guiTop + this.ySize - 6 - 20, HIDE_SELF, () -> this.hideSelf, this::onHideSelfPressed, this::onHideSelfTooltip);
        this.hideOthersWidget = new ToggleImageButton(this.guiLeft + this.xSize - 6 - 20, this.guiTop + this.ySize - 6 - 20, HIDE_OTHERS, () -> this.hideOthers, this::onHideOthersPressed, this::onHideOthersTooltip);
        this.mouthWidget = new MouthWidget(this.mouthWidget, headX, headY + 16, 128, 96, 6, this::onMouthChange);
        this.leftEyeWidget = new EyeAreaWidget(this.leftEyeWidget, headX, headY, 64, 128, 4, 8, true, this::onEyeAreaChange);
        this.rightEyeWidget = new EyeAreaWidget(this.rightEyeWidget, headX + 64, headY, 64, 128, 4, 8, false, this::onEyeAreaChange);
        if (firstInit) {
            this.mouthWidget.setValueNoCallback(8 - this.data.mouth - 1);
            this.updateMouthWidgetMin();
            this.leftEyeWidget.setScleraNoCallback(this.data.leftSclera);
            this.leftEyeWidget.setPupilNoCallback(this.data.leftPupil);
            if (this.data.rightSclera != null) {
                this.rightEyeWidget.setScleraNoCallback(this.data.rightSclera.mutable().offsetX(-4));
                if (this.data.rightPupil != null) {
                    this.rightEyeWidget.setPupilNoCallback(this.data.rightPupil.mutable().offsetX(-4));
                }
            }
        }
        this.m_142416_((GuiEventListener)this.centerPupilWidget);
        this.m_142416_((GuiEventListener)this.hideSelfWidget);
        this.m_142416_((GuiEventListener)this.hideOthersWidget);
        this.m_142416_((GuiEventListener)this.mouthWidget);
        this.m_142416_((GuiEventListener)this.leftEyeWidget);
        this.m_142416_((GuiEventListener)this.rightEyeWidget);
    }

    private void onCenterPupilTooltip(ImageButton imageButton) {
        ArrayList tooltip = new ArrayList();
        if (this.data.centerPupil) {
            imageButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Press to uncenter your eyes.")));
        } else {
            imageButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Press to center your eyes.")));
        }
    }

    private void onCenterPupilTooltip(ImageButton imageButton, GuiGraphics context, Font textRenderer, int mouseX, int mouseY) {
        ArrayList<FormattedCharSequence> tooltip = new ArrayList<FormattedCharSequence>();
        if (this.data.centerPupil) {
            tooltip.add(Component.m_237113_((String)"Press to uncenter your eyes.").m_7532_());
        } else {
            tooltip.add(Component.m_237113_((String)"Press to center your eyes.").m_7532_());
        }
        context.m_280245_(textRenderer, tooltip, mouseX, mouseY);
    }

    private void onCenterPupilPressed(ImageButton widget) {
        this.data = this.data.withCenterPupil(!this.data.centerPupil);
    }

    private void onHideOthersTooltip(ImageButton imageButton) {
        if (this.hideOthers) {
            imageButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Press to enable other players' animations.")));
        } else {
            imageButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Press to disable other players' animations.")));
        }
    }

    private void onHideOthersTooltip(ImageButton imageButton, GuiGraphics context, Font textRenderer, int mouseX, int mouseY) {
        ArrayList<FormattedCharSequence> tooltip = new ArrayList<FormattedCharSequence>();
        if (this.hideOthers) {
            tooltip.add(Component.m_237113_((String)"Press to enable other players' animations.").m_7532_());
        } else {
            tooltip.add(Component.m_237113_((String)"Press to disable other players' animations.").m_7532_());
        }
        context.m_280245_(textRenderer, tooltip, mouseX, mouseY);
    }

    private void onHideOthersPressed(ImageButton imageButton) {
        this.hideOthers = !this.hideOthers;
    }

    private void onHideSelfTooltip(ImageButton imageButton) {
        if (this.hideSelf) {
            imageButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Press to enable your animations.")));
        } else {
            imageButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Press to disable your animations.")));
        }
    }

    private void onHideSelfTooltip(ImageButton imageButton, GuiGraphics context, Font textRenderer, int mouseX, int mouseY) {
        ArrayList<FormattedCharSequence> tooltip = new ArrayList<FormattedCharSequence>();
        if (this.hideSelf) {
            tooltip.add(Component.m_237113_((String)"Press to enable your animations.").m_7532_());
        } else {
            tooltip.add(Component.m_237113_((String)"Press to disable your animations.").m_7532_());
        }
        context.m_280245_(textRenderer, tooltip, mouseX, mouseY);
    }

    private void onHideSelfPressed(ImageButton imageButton) {
        this.hideSelf = !this.hideSelf;
    }

    private void onMouthChange(MouthWidget widget, int value) {
        if (widget == this.mouthWidget) {
            this.data = this.data.withMouth(8 - (value + 1));
        }
    }

    private void onEyeAreaChange(EyeAreaWidget widget, @Nullable Box2i sclera, @Nullable Box2i pupil) {
        if (widget == this.leftEyeWidget) {
            this.data = this.data.withLeftSclera(sclera).withLeftPupil(pupil);
        } else if (widget == this.rightEyeWidget) {
            this.data = this.data.withRightSclera(sclera == null ? null : sclera.mutable().offsetX(4)).withRightPupil(pupil == null ? null : pupil.mutable().offsetX(4));
        }
        this.updateMouthWidgetMin();
    }

    private void updateMouthWidgetMin() {
        this.mouthWidget.setMin(Math.max(this.data.leftSclera == null ? 0 : this.data.leftSclera.maxY(), this.data.rightSclera == null ? 0 : this.data.rightSclera.maxY()));
    }

    public void m_7861_() {
        PlayerInfo entry;
        super.m_7861_();
        RepoHeadsClientConfig config = RepoHeadsClient.getConfig();
        config.data(this.data);
        config.hideSelf(this.hideSelf);
        config.hideOthers(this.hideOthers);
        config.flush();
        ClientPacketListener networkHandler = Minecraft.m_91087_().m_91403_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (networkHandler != null && player != null && (entry = networkHandler.m_104949_(player.m_20148_())) != null) {
            ((RepoPlayerListEntry)entry).setRepoData(this.data);
        }
        RepoHeadsClient.REPO_DATA_SENDER.markDirty();
    }

    public void m_86600_() {
        super.m_86600_();
        for (GuiEventListener element : this.m_6702_()) {
            if (!(element instanceof TickableElement)) continue;
            TickableElement tickableElement = (TickableElement)element;
            tickableElement.tick();
        }
        if (this.mouthWidget.m_274382_()) {
            this.leftEyeWidget.setShowHighlight(false);
            this.rightEyeWidget.setShowHighlight(false);
        } else {
            this.leftEyeWidget.setShowHighlight(true);
            this.rightEyeWidget.setShowHighlight(true);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.m_280163_(TEXTURE, this.guiLeft, this.guiTop, 0.0f, 0.0f, this.xSize, this.ySize, 256, 256);
        guiGraphics.m_286007_(() -> this.renderPlayerHead(guiGraphics, mouseX, mouseY, delta, guiGraphics.m_280168_(), (MultiBufferSource)guiGraphics.m_280091_()));
    }

    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.guiLeft + this.xSize / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, this.guiTop + 5, 0x404040, false);
        super.renderForeground(guiGraphics, mouseX, mouseY, delta);
    }

    private void renderPlayerHead(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta, PoseStack matrices, MultiBufferSource vertexConsumerProvider) {
        assert (this.f_96541_ != null);
        assert (this.f_96541_.f_91074_ != null);
        int x = this.guiLeft + 24;
        int y = this.guiTop + 32;
        ResourceLocation skin = GameProfileUtils.getSkin((UUID)this.f_96541_.f_91074_.m_20148_());
        guiGraphics.m_280411_(skin, x, y, 128, 128, 8.0f, 8.0f, 8, 8, 64, 64);
        guiGraphics.m_280262_();
        RenderSystem.enableBlend();
        guiGraphics.m_280411_(skin, x, y, 128, 128, 40.0f, 8.0f, 8, 8, 64, 64);
        guiGraphics.m_280262_();
        RenderSystem.disableBlend();
    }
}

