/*
 * Decompiled with CFR 0.152.
 */
package com.boyonk.repoheads.client.dummy;

import com.boyonk.repoheads.client.EyeTargetManager;
import com.boyonk.repoheads.client.RepoData;
import com.boyonk.repoheads.client.RepoHeadsClient;
import com.boyonk.repoheads.client.dummy.RepoClientPlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;

public interface RepoPlayerEntityRenderState {
    public static void update(AbstractClientPlayer entity, RepoPlayerEntityRenderState state, float tickDelta) {
        RepoData data = ((RepoClientPlayer)entity).getRepoData();
        boolean hide = entity == Minecraft.m_91087_().f_91074_ ? RepoHeadsClient.getConfig().hideSelf() : RepoHeadsClient.getConfig().hideOthers();
        state.headTexture(RepoHeadsClient.TEXTURES.getTexture(entity));
        state.mouthHeight(data.mouth);
        state.mouthAngle(hide ? 0.0f : ((RepoClientPlayer)entity).getMouthAngle(tickDelta * tickDelta));
        EyeTargetManager targetManager = ((RepoClientPlayer)entity).getEyeTargetManager();
        Vec3 target = targetManager.getTarget(tickDelta);
        if (data.leftSclera == null || data.leftPupil == null) {
            state.leftEye().visible = false;
        } else {
            state.leftEye().visible = true;
            state.leftEye().target = hide ? null : target;
            state.leftEye().eyeRenderUpdater = hide ? Vector2f::new : (x, y) -> targetManager.updateLeftEyeFromRendering(x, y, tickDelta);
            state.leftEye().offsetX = data.leftEyeOffsetX;
            state.leftEye().offsetY = data.leftEyeOffsetY;
            state.leftEye().centerX = data.leftEyeCenterX;
            state.leftEye().centerY = data.leftEyeCenterY;
            state.leftEye().minX = (float)data.leftSclera.minX() - ((float)data.leftPupil.minX() + data.leftEyeOffsetX);
            state.leftEye().minY = (float)data.leftSclera.minY() - ((float)data.leftPupil.minY() + data.leftEyeOffsetY);
            state.leftEye().maxX = (float)data.leftSclera.maxX() - ((float)data.leftPupil.maxX() + data.leftEyeOffsetX);
            state.leftEye().maxY = (float)data.leftSclera.maxY() - ((float)data.leftPupil.maxY() + data.leftEyeOffsetY);
        }
        if (data.rightSclera == null || data.rightPupil == null) {
            state.rightEye().visible = false;
        } else {
            state.rightEye().visible = true;
            state.rightEye().target = hide ? null : target;
            state.rightEye().eyeRenderUpdater = hide ? Vector2f::new : (x, y) -> targetManager.updateRightEyeFromRendering(x, y, tickDelta);
            state.rightEye().offsetX = data.rightEyeOffsetX;
            state.rightEye().offsetY = data.rightEyeOffsetY;
            state.rightEye().centerX = data.rightEyeCenterX;
            state.rightEye().centerY = data.rightEyeCenterY;
            state.rightEye().minX = (float)data.rightSclera.minX() - ((float)data.rightPupil.minX() + data.rightEyeOffsetX);
            state.rightEye().minY = (float)data.rightSclera.minY() - ((float)data.rightPupil.minY() + data.rightEyeOffsetY);
            state.rightEye().maxX = (float)data.rightSclera.maxX() - ((float)data.rightPupil.maxX() + data.rightEyeOffsetX);
            state.rightEye().maxY = (float)data.rightSclera.maxY() - ((float)data.rightPupil.maxY() + data.rightEyeOffsetY);
        }
    }

    public ResourceLocation headTexture();

    public void headTexture(ResourceLocation var1);

    public Eye leftEye();

    public Eye rightEye();

    public float mouthHeight();

    public void mouthHeight(float var1);

    public float mouthAngle();

    public void mouthAngle(float var1);

    public PlayerRenderer renderer();

    public AbstractClientPlayer playerEntity();

    public float tickDelta();

    public void updateExtraFrameInfo(PlayerRenderer var1, AbstractClientPlayer var2, float var3);

    public static class Eye {
        public boolean visible = true;
        @Nullable
        public Vec3 target = Vec3.f_82478_;
        public EyeTargetManager.EyeRenderUpdater eyeRenderUpdater = Vector2f::new;
        public float offsetX;
        public float offsetY;
        public float centerX;
        public float centerY;
        public float minX;
        public float minY;
        public float maxX;
        public float maxY;
    }
}

