/*
 * Decompiled with CFR 0.152.
 */
package com.boyonk.repoheads.client;

import com.boyonk.repoheads.client.Box2i;
import com.boyonk.repoheads.client.RepoData;
import com.boyonk.repoheads.client.dummy.RepoClientPlayer;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;

public class RepoTextures
implements AutoCloseable {
    private final Map<UUID, RepoTexture> texturesByUuid = new HashMap<UUID, RepoTexture>();
    private TextureManager textureManager;

    public void setTextureManager(TextureManager textureManager) {
        this.textureManager = textureManager;
    }

    public ResourceLocation getTexture(AbstractClientPlayer player) {
        RepoTexture repoTexture = this.getOrCreateTexture(player);
        repoTexture.updateTextureIfDirty();
        return repoTexture.textureId;
    }

    private RepoTexture getOrCreateTexture(AbstractClientPlayer player) {
        return this.texturesByUuid.compute(player.m_20148_(), (uuid, repoTexture) -> {
            RepoData data = ((RepoClientPlayer)player).getRepoData();
            ResourceLocation skinTexture = player.m_108560_();
            if (repoTexture == null) {
                return new RepoTexture(player.m_20149_(), data, skinTexture);
            }
            repoTexture.markDirty(data, skinTexture);
            return repoTexture;
        });
    }

    public void removeTexture(AbstractClientPlayer player) {
        RepoTexture repoTexture = this.texturesByUuid.remove(player.m_20148_());
        if (repoTexture != null) {
            repoTexture.close();
        }
    }

    public void clear() {
        for (RepoTexture texture : this.texturesByUuid.values()) {
            texture.close();
        }
        this.texturesByUuid.clear();
    }

    @Override
    public void close() {
        this.clear();
    }

    private static void reset(NativeImage head, NativeImage skin) {
        RepoTextures.copy(skin, 0, 0, head, 0, 0, 64, 16);
        RepoTextures.fill(head, 0, 0, 8, 8, 0);
        RepoTextures.fill(head, 32, 0, 8, 8, 0);
    }

    public static void update(NativeImage head, NativeImage skin, RepoData data) {
        RepoTextures.reset(head, skin);
        if (data.leftSclera != null && data.leftPupil != null) {
            RepoTextures.eye(head, data.leftSclera, data.leftPupil, true);
        }
        if (data.rightSclera != null && data.rightPupil != null) {
            RepoTextures.eye(head, data.rightSclera, data.rightPupil, false);
        }
    }

    private static void eye(NativeImage head, Box2i sclera, Box2i pupil, boolean left) {
        int headLayer = 0;
        int hatLayer = 0;
        for (int x = sclera.minX(); x <= sclera.maxX(); ++x) {
            for (int y = sclera.minY(); y <= sclera.maxY(); ++y) {
                if (pupil.contains(x, y)) continue;
                if (RepoTextures.isOnHat(head, x, y)) {
                    ++hatLayer;
                    continue;
                }
                ++headLayer;
            }
        }
        boolean scleraOnHat = hatLayer > headLayer;
        for (int x = pupil.minX(); x <= pupil.maxX(); ++x) {
            for (int y = pupil.minY(); y <= pupil.maxY(); ++y) {
                if (RepoTextures.isOnHat(head, x, y)) {
                    RepoTextures.setNativeImageColor(head, 32 + x, y, RepoTextures.getNativeImageColor(head, 40 + x, 8 + y));
                    if (scleraOnHat) {
                        RepoTextures.setNativeImageColor(head, 40 + x, 8 + y, RepoTextures.getNearbySclera(head, x, y, sclera, pupil, left, true));
                        continue;
                    }
                    RepoTextures.setNativeImageColor(head, 40 + x, 8 + y, 0);
                    continue;
                }
                RepoTextures.setNativeImageColor(head, x, y, RepoTextures.getNativeImageColor(head, 8 + x, 8 + y));
                RepoTextures.setNativeImageColor(head, 8 + x, 8 + y, RepoTextures.getNearbySclera(head, x, y, sclera, pupil, left, false));
            }
        }
    }

    private static int getNearbySclera(NativeImage image, int x, int y, Box2i sclera, Box2i pupil, boolean left, boolean scleraOnHat) {
        int pixelX = scleraOnHat ? 40 : 8;
        int pixelY = 8;
        int radius = 0;
        boolean tryAgain = true;
        while (tryAgain) {
            int yOffset;
            int xOffset;
            tryAgain = false;
            int n = xOffset = left ? radius : -(++radius);
            if (sclera.contains(x + xOffset, y)) {
                tryAgain = true;
                if (!pupil.contains(x + xOffset, y)) {
                    return RepoTextures.getNativeImageColor(image, pixelX + x + xOffset, pixelY + y);
                }
            }
            if (sclera.contains(x - xOffset, y)) {
                tryAgain = true;
                if (!pupil.contains(x - xOffset, y)) {
                    return RepoTextures.getNativeImageColor(image, pixelX + x - xOffset, pixelY + y);
                }
            }
            if (sclera.contains(x, y - (yOffset = radius))) {
                tryAgain = true;
                if (!pupil.contains(x, y - yOffset)) {
                    return RepoTextures.getNativeImageColor(image, pixelX + x, pixelY + y - yOffset);
                }
            }
            if (!sclera.contains(x, y + yOffset)) continue;
            tryAgain = true;
            if (pupil.contains(x, y + yOffset)) continue;
            return RepoTextures.getNativeImageColor(image, pixelX + x, pixelY + y + yOffset);
        }
        return RepoTextures.getNativeImageColor(image, pixelX + x, pixelY + y);
    }

    private static void setNativeImageColor(NativeImage image, int x, int y, int color) {
        image.m_84988_(x, y, color);
    }

    private static int getNativeImageColor(NativeImage image, int x, int y) {
        return image.m_84985_(x, y);
    }

    private static boolean isOnHat(NativeImage image, int headX, int headY) {
        return FastColor.ARGB32.m_13655_((int)RepoTextures.getNativeImageColor(image, 40 + headX, 8 + headY)) == 255;
    }

    public static void copy(NativeImage fromImage, int fromX, int fromY, NativeImage toImage, int toX, int toY, int width, int height) {
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int color = RepoTextures.getNativeImageColor(fromImage, fromX + x, fromY + y);
                RepoTextures.setNativeImageColor(toImage, toX + x, toY + y, color);
            }
        }
    }

    private static void fill(NativeImage image, int x, int y, int width, int height, int color) {
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                RepoTextures.setNativeImageColor(image, x + i, y + j, color);
            }
        }
    }

    private class RepoTexture
    implements AutoCloseable {
        private RepoData data;
        private ResourceLocation skinTexture;
        private final DynamicTexture texture;
        private boolean dirty = true;
        final ResourceLocation textureId;

        RepoTexture(String uuidAsString, RepoData data, ResourceLocation skinTexture) {
            this.data = data;
            this.skinTexture = skinTexture;
            this.texture = new DynamicTexture(64, 16, true);
            this.textureId = ResourceLocation.m_214293_((String)"repo-heads", (String)("player/" + uuidAsString));
            RepoTextures.this.textureManager.m_118495_(this.textureId, (AbstractTexture)this.texture);
        }

        void markDirty(RepoData data, ResourceLocation skinTexture) {
            boolean dirty = this.data != data || this.skinTexture != skinTexture;
            this.data = data;
            this.skinTexture = skinTexture;
            this.dirty = dirty;
        }

        void updateTextureIfDirty() {
            if (this.dirty) {
                NativeImage skin;
                boolean closeSkin = false;
                AbstractTexture skinTexture = RepoTextures.this.textureManager.m_118506_(this.skinTexture);
                if (skinTexture instanceof DynamicTexture) {
                    DynamicTexture imageBackedTexture = (DynamicTexture)skinTexture;
                    skin = imageBackedTexture.m_117991_();
                } else {
                    RenderSystem.assertOnRenderThread();
                    RenderSystem.bindTexture((int)skinTexture.m_117963_());
                    skin = new NativeImage(64, 64, true);
                    skin.m_85045_(0, false);
                    closeSkin = true;
                }
                RepoTextures.update(this.texture.m_117991_(), skin, this.data);
                if (closeSkin) {
                    skin.close();
                }
                this.texture.m_117985_();
                this.dirty = false;
            }
        }

        @Override
        public void close() {
            this.texture.close();
        }
    }
}

