/*
 * Decompiled with CFR 0.152.
 */
package com.boyonk.repoheads.client;

import com.boyonk.repoheads.client.RepoHeadsClient;
import de.maxhenkel.voicechat.api.ClientVoicechatSocket;
import de.maxhenkel.voicechat.api.RawUdpPacket;
import de.maxhenkel.voicechat.plugins.impl.ClientVoicechatSocketImpl;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientNetworkMessage;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.ClientVoicechatConnection;
import de.maxhenkel.voicechat.voice.common.NetworkMessage;
import de.maxhenkel.voicechat.voice.common.Packet;
import de.maxhenkel.voicechat.voice.common.PlayerSoundPacket;
import java.net.SocketAddress;

public class RepoHeadsSocket
implements ClientVoicechatSocket {
    private final ClientVoicechatSocket delegate;

    public RepoHeadsSocket(ClientVoicechatSocket delegate) {
        if (delegate == null) {
            delegate = new ClientVoicechatSocketImpl();
        }
        this.delegate = delegate;
    }

    public void open() throws Exception {
        this.delegate.open();
    }

    public RawUdpPacket read() throws Exception {
        RawUdpPacket packet = this.delegate.read();
        ClientVoicechat client = ClientManager.getClient();
        if (client == null) {
            return packet;
        }
        ClientVoicechatConnection connection = client.getConnection();
        if (connection == null) {
            return packet;
        }
        NetworkMessage message = ClientNetworkMessage.readPacketClient((RawUdpPacket)packet, (ClientVoicechatConnection)connection);
        if (message == null) {
            return packet;
        }
        Packet packet2 = message.getPacket();
        if (!(packet2 instanceof PlayerSoundPacket)) {
            return packet;
        }
        PlayerSoundPacket playerSoundPacket = (PlayerSoundPacket)packet2;
        RepoHeadsClient.onPlayerSoundPacket(playerSoundPacket);
        return packet;
    }

    public void send(byte[] data, SocketAddress address) throws Exception {
        this.delegate.send(data, address);
    }

    public void close() {
        this.delegate.close();
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }
}

