/*
 * Decompiled with CFR 0.152.
 */
package com.boyonk.repoheads.client;

import com.boyonk.repoheads.client.RepoData;
import com.boyonk.repoheads.client.RepoDataSender;
import com.boyonk.repoheads.client.RepoHeadsAudioUtils;
import com.boyonk.repoheads.client.RepoHeadsClientConfig;
import com.boyonk.repoheads.client.RepoHeadsSocket;
import com.boyonk.repoheads.client.RepoTextures;
import com.boyonk.repoheads.client.VoicechatEventListener;
import com.boyonk.repoheads.client.dummy.RepoClientPlayer;
import com.boyonk.repoheads.client.dummy.RepoPlayerListEntry;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.maxhenkel.voicechat.api.ClientVoicechatSocket;
import de.maxhenkel.voicechat.api.ForgeVoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.events.ClientReceiveSoundEvent;
import de.maxhenkel.voicechat.api.events.ClientSoundEvent;
import de.maxhenkel.voicechat.api.events.ClientVoicechatInitializationEvent;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.voice.common.PlayerSoundPacket;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ForgeVoicechatPlugin
@Mod(value="repo_heads")
public final class RepoHeadsClient
implements VoicechatPlugin,
VoicechatEventListener {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Repo Heads");
    public static final String NAMESPACE = "repo-heads";
    public static final String MOD_ID = "repo_heads";
    public static VoicechatEventListener listener = VoicechatEventListener.EMPTY;
    private static final RepoHeadsClientConfig config = RepoHeadsClientConfig.load();
    public static final RepoDataSender REPO_DATA_SENDER = new RepoDataSender();
    public static final RepoTextures TEXTURES = new RepoTextures();
    public static final BiFunction<ResourceLocation, Boolean, RenderType> ENTITY_TRANSLUCENT_OFFSET = Util.m_143821_((texture, affectsOutline) -> {
        RenderType.CompositeState multiPhaseParameters = RenderType.CompositeState.m_110628_().m_110669_(RenderStateShard.f_110118_).m_173292_(RenderStateShard.f_173066_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(RenderStateShard.f_110139_).m_110661_(RenderStateShard.f_110110_).m_110671_(RenderStateShard.f_110152_).m_110677_(RenderStateShard.f_110154_).m_110691_(affectsOutline.booleanValue());
        return RenderType.m_173215_((String)"entity_translucent_offset", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)true, (boolean)true, (RenderType.CompositeState)multiPhaseParameters);
    });

    public static void onPlayerSoundPacket(PlayerSoundPacket playerSoundPacket) {
        if (playerSoundPacket.getData().length > 0) {
            return;
        }
        ClientPacketListener networkHandler = Minecraft.m_91087_().m_91403_();
        if (networkHandler == null) {
            return;
        }
        PlayerInfo entry = networkHandler.m_104949_(playerSoundPacket.getSender());
        if (entry == null) {
            return;
        }
        long sequenceNumber = playerSoundPacket.getSequenceNumber();
        if (!RepoData.isValid(sequenceNumber)) {
            return;
        }
        RepoData repoData = RepoData.unpack(sequenceNumber);
        ((RepoPlayerListEntry)entry).setRepoData(repoData);
    }

    public RepoHeadsClient() {
        listener = this;
    }

    @Override
    public void onClientSound(ClientSoundEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        short[] audio = event.getRawAudio();
        REPO_DATA_SENDER.refreshLastTalked();
        ((RepoClientPlayer)player).updateAudioLevel(RepoHeadsAudioUtils.getHighestAudioLevel(audio));
    }

    @Override
    public void onEntitySound(ClientReceiveSoundEvent.EntitySound event) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        Player player = world.m_46003_(event.getId());
        if (player == null) {
            return;
        }
        short[] audio = event.getRawAudio();
        ((RepoClientPlayer)player).updateAudioLevel(RepoHeadsAudioUtils.getHighestAudioLevel(audio));
    }

    @Override
    public void onClientVoicechatInitialization(ClientVoicechatInitializationEvent event) {
        event.setSocketImplementation((ClientVoicechatSocket)new RepoHeadsSocket(event.getSocketImplementation()));
    }

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(ClientSoundEvent.class, event -> listener.onClientSound((ClientSoundEvent)event));
        registration.registerEvent(ClientReceiveSoundEvent.EntitySound.class, event -> listener.onEntitySound((ClientReceiveSoundEvent.EntitySound)event));
        registration.registerEvent(ClientVoicechatInitializationEvent.class, event -> listener.onClientVoicechatInitialization((ClientVoicechatInitializationEvent)event));
    }

    public String getPluginId() {
        return MOD_ID;
    }

    public static RepoHeadsClientConfig getConfig() {
        return config;
    }

    @Mod.EventBusSubscriber(modid="repo_heads", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onPlayerDisappeared(EntityLeaveLevelEvent event) {
            Entity entity = event.getEntity();
            if (entity instanceof AbstractClientPlayer) {
                AbstractClientPlayer player = (AbstractClientPlayer)entity;
                TEXTURES.removeTexture(player);
            }
        }

        @SubscribeEvent
        public static void onTick(TickEvent.ClientTickEvent event) {
            if (event.type == TickEvent.Type.CLIENT && event.phase == TickEvent.Phase.END) {
                REPO_DATA_SENDER.update();
            }
        }
    }
}

