/*
 * Decompiled with CFR 0.152.
 */
package com.boyonk.repoheads.client;

import com.boyonk.repoheads.client.RepoData;
import com.boyonk.repoheads.client.RepoHeadsClient;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.ClientVoicechatConnection;
import de.maxhenkel.voicechat.voice.common.MicPacket;
import de.maxhenkel.voicechat.voice.common.NetworkMessage;
import de.maxhenkel.voicechat.voice.common.Packet;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RepoDataSender {
    private static final long REGULAR_UPDATE_INTERVAL_MILLIS = 2000L;
    private static final long WAIT_SINCE_LAST_TALK_MILLIS = 1000L;
    @Nullable
    private ClientLevel prevWorld = null;
    @Nullable
    private LocalPlayer prevPlayer = null;
    private boolean dirty = false;
    private List<Player> players = List.of();
    private long lastSent = -1L;
    private long lastTalked = -1L;

    public void update() {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (world != this.prevWorld || world == null || player != this.prevPlayer || player == null) {
            this.prevWorld = world;
            this.prevPlayer = player;
            this.reset();
            return;
        }
        double distance = 64.0;
        double distanceSquared = distance * distance;
        this.updatePlayers(world.m_142425_((EntityTypeTest)EntityType.f_20532_, AABB.m_165882_((Vec3)player.m_20182_(), (double)distance, (double)distance, (double)distance), entity -> entity != player && entity.m_20280_((Entity)player) < distanceSquared));
        if (this.shouldSend()) {
            this.trySend();
        }
    }

    public void updatePlayers(List<Player> players) {
        HashSet<Player> added = new HashSet<Player>();
        HashSet<Player> removed = new HashSet<Player>();
        for (Player player : players) {
            if (this.players.contains(player)) continue;
            added.add(player);
        }
        for (Player player : this.players) {
            if (players.contains(player)) continue;
            removed.add(player);
        }
        if (!added.isEmpty() || !removed.isEmpty()) {
            this.markDirty();
            this.players = players;
        }
    }

    public void reset() {
        this.dirty = true;
        this.players = List.of();
        this.lastSent = -1L;
        this.lastTalked = -1L;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public boolean shouldSend() {
        return (this.dirty || System.currentTimeMillis() - this.lastSent > 2000L) && System.currentTimeMillis() - this.lastTalked > 1000L;
    }

    public void trySend() {
        block5: {
            ClientVoicechat client = ClientManager.getClient();
            if (client == null) {
                return;
            }
            ClientVoicechatConnection connection = client.getConnection();
            if (connection == null) {
                return;
            }
            if (!connection.isConnected()) {
                return;
            }
            try {
                connection.sendToServer(new NetworkMessage((Packet)new MicPacket(new byte[0], false, RepoData.pack(RepoHeadsClient.getConfig().data()))));
            }
            catch (Exception e) {
                RepoHeadsClient.LOGGER.error("Tried to send voice chat packet but failed - Disconnecting", new Object[]{e});
                if (!connection.isConnected()) break block5;
                connection.disconnect();
            }
        }
        this.dirty = false;
        this.lastSent = System.currentTimeMillis();
    }

    public void refreshLastTalked() {
        this.lastTalked = System.currentTimeMillis();
    }
}

