/*
 * Decompiled with CFR 0.152.
 */
package com.boyonk.repoheads.client;

public interface Box2i {
    public int minX();

    public int minY();

    public int maxX();

    public int maxY();

    public Immutable immutable();

    default public Mutable mutable() {
        return new Mutable(this.minX(), this.minY(), this.maxX(), this.maxY());
    }

    default public int width() {
        return this.maxX() + 1 - this.minX();
    }

    default public int height() {
        return this.maxY() + 1 - this.minY();
    }

    default public int area() {
        return this.width() * this.height();
    }

    default public boolean contains(int x, int y) {
        return x >= this.minX() && x <= this.maxX() && y >= this.minY() && y <= this.maxY();
    }

    default public boolean contains(Box2i other) {
        return this.contains(other.minX(), other.minY()) && this.contains(other.maxX(), other.maxY());
    }

    public static Immutable immutable(int x1, int y1, int x2, int y2) {
        int minX = Math.min(x1, x2);
        int minY = Math.min(y1, y2);
        int maxX = Math.max(x1, x2);
        int maxY = Math.max(y1, y2);
        return new Immutable(minX, minY, maxX, maxY);
    }

    public static Mutable mutable(int x1, int y1, int x2, int y2) {
        int minX = Math.min(x1, x2);
        int minY = Math.min(y1, y2);
        int maxX = Math.max(x1, x2);
        int maxY = Math.max(y1, y2);
        return new Mutable(minX, minY, maxX, maxY);
    }

    public static class Mutable
    implements Box2i {
        private int minX;
        private int minY;
        private int maxX;
        private int maxY;

        private Mutable(int minX, int minY, int maxX, int maxY) {
            this.minX = minX;
            this.minY = minY;
            this.maxX = maxX;
            this.maxY = maxY;
        }

        @Override
        public int minX() {
            return this.minX;
        }

        @Override
        public int minY() {
            return this.minY;
        }

        @Override
        public int maxX() {
            return this.maxX;
        }

        @Override
        public int maxY() {
            return this.maxY;
        }

        public Mutable minX(int minX) {
            if (minX > this.maxX) {
                throw new IllegalArgumentException("minX cannot be greater than maxX");
            }
            this.minX = minX;
            return this;
        }

        public Mutable minY(int minY) {
            if (minY > this.maxY) {
                throw new IllegalArgumentException("minY cannot be greater than maxY");
            }
            this.minY = minY;
            return this;
        }

        public Mutable maxX(int maxX) {
            if (maxX < this.minX) {
                throw new IllegalArgumentException("maxX cannot be less than minX");
            }
            this.maxX = maxX;
            return this;
        }

        public Mutable maxY(int maxY) {
            if (maxY < this.minY) {
                throw new IllegalArgumentException("maxY cannot be less than minY");
            }
            this.maxY = maxY;
            return this;
        }

        public Mutable min(int minX, int minY) {
            return this.minX(minX).minY(minY);
        }

        public Mutable max(int maxX, int maxY) {
            return this.maxX(maxX).maxY(maxY);
        }

        public Mutable x1(int x1) {
            if (x1 > this.maxX) {
                this.maxX = x1;
            } else {
                this.minX = x1;
            }
            return this;
        }

        public Mutable y1(int y1) {
            if (y1 > this.maxY) {
                this.maxY = y1;
            } else {
                this.minY = y1;
            }
            return this;
        }

        public Mutable x2(int x2) {
            if (x2 < this.minX) {
                this.minX = x2;
            } else {
                this.maxX = x2;
            }
            return this;
        }

        public Mutable y2(int y2) {
            if (y2 < this.minY) {
                this.minY = y2;
            } else {
                this.maxY = y2;
            }
            return this;
        }

        public Mutable offset(int x, int y) {
            return this.offsetX(x).offsetY(y);
        }

        public Mutable offsetX(int x) {
            this.minX += x;
            this.maxX += x;
            return this;
        }

        public Mutable offsetY(int y) {
            this.minY += y;
            this.maxY += y;
            return this;
        }

        @Override
        public Immutable immutable() {
            return new Immutable(this.minX, this.minY, this.maxX, this.maxY);
        }

        public String toString() {
            return "Box2i.Mutable[" + this.minX + ", " + this.minY + ", " + this.maxX + ", " + this.maxY + "]";
        }
    }

    public static class Immutable
    implements Box2i {
        private final int minX;
        private final int minY;
        private final int maxX;
        private final int maxY;

        private Immutable(int minX, int minY, int maxX, int maxY) {
            this.minX = minX;
            this.minY = minY;
            this.maxX = maxX;
            this.maxY = maxY;
        }

        @Override
        public int minX() {
            return this.minX;
        }

        @Override
        public int minY() {
            return this.minY;
        }

        @Override
        public int maxX() {
            return this.maxX;
        }

        @Override
        public int maxY() {
            return this.maxY;
        }

        public Immutable offset(int x, int y) {
            return new Immutable(this.minX + x, this.minY + y, this.maxX + x, this.maxY + y);
        }

        public Immutable offsetX(int x) {
            return new Immutable(this.minX + x, this.minY, this.maxX + x, this.maxY);
        }

        public Immutable offsetY(int y) {
            return new Immutable(this.minX, this.minY + y, this.maxX, this.maxY + y);
        }

        @Override
        public Immutable immutable() {
            return this;
        }

        public String toString() {
            return "Box2i.Immutable[" + this.minX + ", " + this.minY + ", " + this.maxX + ", " + this.maxY + "]";
        }
    }
}

