/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LargeTableBlock
extends HorizontalDirectionalBlock {
    public static final EnumProperty<BedPart> PART = BlockStateProperties.f_61391_;
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0625, (double)0.9375, (double)0.875, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.9375, (double)0.0625, (double)0.9375, (double)0.96875, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.875, (double)0.0, (double)1.0, (double)1.0, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.875, (double)0.9375, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.9375, (double)0.875, (double)0.0625, (double)1.0, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, GeneralUtil.rotateShape((Direction)Direction.EAST, (Direction)direction, (VoxelShape)voxelShapeSupplier.get()));
        }
    });
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public LargeTableBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(PART, (Comparable)BedPart.FOOT));
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == LargeTableBlock.getDirectionTowardsOtherPart((BedPart)state.m_61143_(PART), (Direction)state.m_61143_((Property)FACING))) {
            return neighborState.m_60713_((Block)this) && neighborState.m_61143_(PART) != state.m_61143_(PART) ? state : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    private static Direction getDirectionTowardsOtherPart(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.m_122424_();
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.f_46443_ && player.m_7500_()) {
            this.removeOtherPart(world, pos, state, player);
        }
        super.m_5707_(world, pos, state, player);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction direction = ctx.m_8125_().m_122427_();
        BlockPos blockPos = ctx.m_8083_();
        BlockPos blockPos2 = blockPos.m_121945_(direction);
        Level world = ctx.m_43725_();
        return world.m_8055_(blockPos2).m_60629_(ctx) && world.m_6857_().m_61937_(blockPos2) ? (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction) : null;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = LargeTableBlock.getOppositePartDirection(state).m_122424_();
        return SHAPE.get(direction);
    }

    public static Direction getOppositePartDirection(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return state.m_61143_(PART) == BedPart.HEAD ? direction.m_122424_() : direction;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.m_6402_(world, pos, state, placer, itemStack);
        if (!world.f_46443_) {
            this.placeOtherPart(world, pos, state);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, PART});
    }

    private void placeOtherPart(Level world, BlockPos pos, BlockState state) {
        BlockPos blockPos = pos.m_121945_((Direction)state.m_61143_((Property)FACING));
        world.m_7731_(blockPos, (BlockState)state.m_61124_(PART, (Comparable)BedPart.HEAD), 3);
        world.m_6289_(pos, Blocks.f_50016_);
        state.m_60701_((LevelAccessor)world, pos, 3);
    }

    private void removeOtherPart(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockPos;
        BlockState blockState;
        BedPart bedPart = (BedPart)state.m_61143_(PART);
        if (bedPart == BedPart.FOOT && (blockState = world.m_8055_(blockPos = pos.m_121945_(LargeTableBlock.getDirectionTowardsOtherPart(bedPart, (Direction)state.m_61143_((Property)FACING))))).m_60713_((Block)this) && blockState.m_61143_(PART) == BedPart.HEAD) {
            world.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 35);
            if (player != null) {
                world.m_5898_(player, 2001, blockPos, Block.m_49956_((BlockState)blockState));
            }
        }
    }
}

