/*
 * Decompiled with CFR 0.152.
 */
package fox.mods.essentialscommands.utils;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import fox.mods.essentialscommands.utils.Home;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class HomeManager {
    private static final Gson gson = new Gson();
    private static final Type homeMapType = new TypeToken<Map<String, List<Home>>>(){}.getType();
    private static Map<String, List<Home>> homes = new HashMap<String, List<Home>>();
    private static final String FILE_PATH = "config/homes.json";

    public static void saveHomes() {
        try (FileWriter writer = new FileWriter(FILE_PATH);){
            gson.toJson(homes, homeMapType, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadHomes() {
        try (FileReader reader = new FileReader(FILE_PATH);){
            homes = (Map)gson.fromJson((Reader)reader, homeMapType);
            if (homes == null) {
                homes = new HashMap<String, List<Home>>();
            }
        }
        catch (IOException e) {
            homes = new HashMap<String, List<Home>>();
        }
    }

    public static boolean addHome(UUID playerUUID, Home home) {
        String playerId = playerUUID.toString();
        homes.putIfAbsent(playerId, new ArrayList());
        List<Home> playerHomes = homes.get(playerId);
        for (Home h : playerHomes) {
            if (!h.getName().equalsIgnoreCase(home.getName())) continue;
            return false;
        }
        playerHomes.add(home);
        HomeManager.saveHomes();
        return true;
    }

    public static Home getHome(UUID playerUUID, String homeName) {
        List<Home> playerHomes = homes.get(playerUUID.toString());
        if (playerHomes == null) {
            return null;
        }
        for (Home h : playerHomes) {
            if (!h.getName().equalsIgnoreCase(homeName)) continue;
            return h;
        }
        return null;
    }

    public static boolean deleteHome(UUID playerUUID, String homeName) {
        List<Home> playerHomes = homes.get(playerUUID.toString());
        if (playerHomes == null) {
            return false;
        }
        boolean removed = playerHomes.removeIf(h -> h.getName().equalsIgnoreCase(homeName));
        if (removed) {
            HomeManager.saveHomes();
        }
        return removed;
    }

    public static int getPlayerHomeCount(UUID playerUUID) {
        List<Home> playerHomes = homes.get(playerUUID.toString());
        return playerHomes != null ? playerHomes.size() : 0;
    }

    static {
        HomeManager.loadHomes();
    }
}

