/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.utils;

import com.mna.api.capabilities.IPlayerMagic;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import org.sosly.arcaneadditions.capabilities.familiar.FamiliarProvider;
import org.sosly.arcaneadditions.capabilities.familiar.IFamiliarCapability;
import org.sosly.arcaneadditions.entities.ai.CastOffensiveSpell;
import org.sosly.arcaneadditions.entities.ai.CastUtilitySpell;
import org.sosly.arcaneadditions.entities.ai.CasterHurtByTargetGoal;
import org.sosly.arcaneadditions.entities.ai.CasterHurtTargetGoal;
import org.sosly.arcaneadditions.entities.ai.FollowCasterGoal;
import org.sosly.arcaneadditions.entities.ai.NeverTargetCasterGoal;
import org.sosly.arcaneadditions.entities.ai.RandomWanderGoal;
import org.sosly.arcaneadditions.entities.ai.StayWhenOrderedToGoal;

public class FamiliarHelper {
    private static final String CASTER = "arcaneadditions:familiar/caster";

    public static boolean createFamiliar(Player caster, EntityType<? extends Mob> type, Component name, Level level, BlockPos pos) {
        IFamiliarCapability cap = FamiliarHelper.getFamiliarCapability(caster);
        IPlayerMagic magic = FamiliarHelper.getMagicCapability(caster);
        if (cap == null || magic == null) {
            return false;
        }
        Mob familiar = (Mob)type.m_20615_(level);
        if (familiar == null) {
            return false;
        }
        if (cap.getFamiliarNBT() != null) {
            familiar.m_20258_(cap.getFamiliarNBT());
            familiar.m_146884_(Vec3.m_82539_((Vec3i)pos.m_7494_()));
            familiar.m_20256_(Vec3.f_82478_);
            familiar.f_19789_ = 0.0f;
            familiar.m_20095_();
            if (!familiar.m_8077_()) {
                familiar.m_6593_(name);
                familiar.m_20340_(true);
            }
        } else {
            familiar.m_146884_(Vec3.m_82539_((Vec3i)pos.m_7494_()));
            familiar.m_6593_(name);
            familiar.m_20340_(true);
        }
        familiar.getPersistentData().m_128362_(CASTER, caster.m_20148_());
        FamiliarHelper.setupFamiliarAI(familiar);
        if (!level.m_7967_((Entity)familiar)) {
            return false;
        }
        cap.setCaster(caster);
        cap.setFamiliar(familiar);
        cap.setType(type);
        cap.setName(familiar.m_7770_() != null ? familiar.m_7770_().getString() : name.getString());
        cap.getCastingResource().setMaxAmountByLevel(magic.getMagicLevel() / 5);
        if (cap.getCastingResource().getMaxAmount() < cap.getCastingResource().getAmount()) {
            cap.getCastingResource().setAmount(cap.getCastingResource().getMaxAmount());
        }
        cap.setBapped(false);
        cap.setOrderedToStay(false);
        cap.setLastInteract(level.m_46467_());
        return true;
    }

    public static Player getCaster(Mob familiar) {
        IFamiliarCapability cap = FamiliarHelper.getFamiliarCapability(familiar);
        if (cap == null) {
            return null;
        }
        return cap.getCaster();
    }

    public static Mob getFamiliar(Player caster) {
        IFamiliarCapability cap = FamiliarHelper.getFamiliarCapability(caster);
        if (cap == null) {
            return null;
        }
        return cap.getFamiliar();
    }

    public static IFamiliarCapability getFamiliarCapability(Mob mob) {
        if (!mob.getPersistentData().m_128403_(CASTER)) {
            return null;
        }
        Player caster = mob.m_9236_().m_46003_(mob.getPersistentData().m_128342_(CASTER));
        if (caster == null) {
            mob.m_142687_(Entity.RemovalReason.DISCARDED);
            return null;
        }
        LazyOptional loCap = caster.getCapability(FamiliarProvider.FAMILIAR);
        if (!loCap.isPresent() || loCap.resolve().isEmpty()) {
            return null;
        }
        return (IFamiliarCapability)loCap.resolve().get();
    }

    public static IFamiliarCapability getFamiliarCapability(Player caster) {
        LazyOptional loCap = caster.getCapability(FamiliarProvider.FAMILIAR);
        if (!loCap.isPresent() || loCap.resolve().isEmpty()) {
            return null;
        }
        return (IFamiliarCapability)loCap.resolve().get();
    }

    private static IPlayerMagic getMagicCapability(Player caster) {
        LazyOptional loCap = caster.getCapability(PlayerMagicProvider.MAGIC);
        if (!loCap.isPresent() || loCap.resolve().isEmpty()) {
            return null;
        }
        return (IPlayerMagic)loCap.resolve().get();
    }

    public static boolean hasFamiliar(Player caster) {
        LazyOptional cap = caster.getCapability(FamiliarProvider.FAMILIAR);
        return cap.isPresent();
    }

    public static boolean isFamiliar(Mob mob) {
        return mob.getPersistentData().m_128403_(CASTER);
    }

    public static boolean isOrphaned(Mob familiar) {
        if (!familiar.getPersistentData().m_128403_(CASTER)) {
            return false;
        }
        Player caster = familiar.m_9236_().m_46003_(familiar.getPersistentData().m_128342_(CASTER));
        return caster == null;
    }

    public static void removeFamiliar(Player caster) {
        IFamiliarCapability cap = FamiliarHelper.getFamiliarCapability(caster);
        if (cap == null) {
            return;
        }
        if (cap.getFamiliar() != null) {
            cap.storeFamiliarData();
            cap.getFamiliar().m_142687_(Entity.RemovalReason.DISCARDED);
            caster.m_213846_((Component)Component.m_237115_((String)"arcaneadditions:rituals/bind_familiar.already_bound"));
        }
        cap.reset();
    }

    public static void setupFamiliarAI(Mob familiar) {
        familiar.m_147272_();
        familiar.f_21345_.m_25352_(2, (Goal)new StayWhenOrderedToGoal(familiar));
        familiar.f_21345_.m_25352_(5, (Goal)new CastOffensiveSpell(familiar, 256.0f));
        familiar.f_21345_.m_25352_(6, (Goal)new FollowCasterGoal(familiar, 1.0, 20.0f, 2.0f, 16.0f, false));
        familiar.f_21345_.m_25352_(7, (Goal)new CastUtilitySpell(familiar, 256.0f));
        familiar.f_21345_.m_25352_(10, (Goal)new RandomWanderGoal(familiar, 1.0, 20));
        familiar.f_21346_.m_25352_(0, (Goal)new NeverTargetCasterGoal(familiar));
        familiar.f_21346_.m_25352_(1, (Goal)new CasterHurtByTargetGoal(familiar));
        familiar.f_21346_.m_25352_(2, (Goal)new CasterHurtTargetGoal(familiar));
    }

    public static int calculateSpellcastingProbability(int initialProbability, int elapsedSeconds) {
        double linearStart = (double)initialProbability * 0.75;
        double exponentialEnd = (double)initialProbability * 1.25;
        double linearEndProbability = (double)initialProbability / 1.5;
        double linearRate = ((double)initialProbability - linearEndProbability) / ((double)initialProbability - linearStart);
        double k = 0.2;
        if ((double)elapsedSeconds < linearStart) {
            return initialProbability;
        }
        if (elapsedSeconds < initialProbability) {
            return (int)((double)initialProbability - linearRate * ((double)elapsedSeconds - linearStart));
        }
        if ((double)elapsedSeconds <= exponentialEnd) {
            double startProbPhase3 = (double)initialProbability - linearRate * ((double)initialProbability - linearStart);
            return (int)(startProbPhase3 / Math.exp(k * (double)(elapsedSeconds - initialProbability)));
        }
        return 1;
    }
}

