/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.spells.shapes;

import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.Shape;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.sosly.arcaneadditions.utils.FamiliarHelper;

public class FamiliarShape
extends Shape {
    public FamiliarShape(ResourceLocation icon) {
        super(icon, new AttributeValuePair[0]);
    }

    public List<SpellTarget> Target(SpellSource source, Level level, IModifiedSpellPart<Shape> modifiedData, ISpellDefinition recipe) {
        if (source.getCaster() == null) {
            return null;
        }
        if (source.getCaster() instanceof Player) {
            Player player = (Player)source.getCaster();
            Mob familiar = FamiliarHelper.getFamiliar(player);
            if (familiar == null) {
                return null;
            }
            return List.of(new SpellTarget((Entity)familiar));
        }
        Mob familiar = (Mob)source.getCaster();
        Player player = FamiliarHelper.getCaster(familiar);
        if (player == null) {
            return null;
        }
        return List.of(new SpellTarget((Entity)player));
    }

    public float initialComplexity() {
        return 5.0f;
    }

    public int requiredXPForRote() {
        return 100;
    }

    public SpellPartTags getUseTag() {
        return SpellPartTags.FRIENDLY;
    }

    public boolean affectsCaster() {
        return false;
    }

    public boolean canBeOnRandomStaff() {
        return false;
    }
}

