/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.spells.components;

import com.mna.api.affinity.Affinity;
import com.mna.api.faction.IFaction;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.factions.Factions;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkHooks;
import org.sosly.arcaneadditions.capabilities.treestride.TreestrideProvider;
import org.sosly.arcaneadditions.gui.menus.TreeStrideMenu;
import org.sosly.arcaneadditions.utils.TreeFinder;

public class TreeStrideComponent
extends SpellEffect {
    public TreeStrideComponent(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair[0]);
    }

    public ComponentApplicationResult ApplyEffect(SpellSource spellSource, SpellTarget spellTarget, IModifiedSpellPart<SpellEffect> iModifiedSpellPart, SpellContext spellContext) {
        ServerPlayer player;
        if (!spellSource.isPlayerCaster() || !spellTarget.isBlock()) {
            return ComponentApplicationResult.FAIL;
        }
        Player player2 = spellSource.getPlayer();
        if (!(player2 instanceof ServerPlayer) || !((player2 = (player = (ServerPlayer)player2).m_9236_()) instanceof ServerLevel)) {
            return ComponentApplicationResult.FAIL;
        }
        ServerLevel level = (ServerLevel)player2;
        BlockPos pos = spellTarget.getBlock();
        BlockState state = level.m_8055_(pos);
        if (!TreeFinder.isBlockALog(state) || !TreeFinder.isPartOfATree((Level)level, pos, true)) {
            return ComponentApplicationResult.FAIL;
        }
        Set<BlockPos> roots = TreeFinder.getRootBlocks((Level)level, pos, blockPos -> TreeFinder.isBlockALog((Level)level, blockPos));
        BlockPos root = TreeStrideComponent.findRootBlock(roots, pos);
        ServerPlayer caster = (ServerPlayer)spellSource.getPlayer();
        level.getCapability(TreestrideProvider.TREESTRIDE).ifPresent(treestride -> treestride.setCurrentPosition(caster, root));
        SimpleMenuProvider container = new SimpleMenuProvider(TreeStrideMenu::new, (Component)Component.m_237115_((String)"arcaneadditions:components/tree_stride"));
        NetworkHooks.openScreen((ServerPlayer)caster, (MenuProvider)container);
        return ComponentApplicationResult.SUCCESS;
    }

    public Affinity getAffinity() {
        return Affinity.EARTH;
    }

    public IFaction getFactionRequirement() {
        return Factions.FEY;
    }

    public float initialComplexity() {
        return 50.0f;
    }

    public int requiredXPForRote() {
        return 100;
    }

    public static BlockPos findRootBlock(Set<BlockPos> blocks, BlockPos start) {
        AtomicReference<BlockPos> root = new AtomicReference<BlockPos>(start);
        blocks.forEach(block -> {
            if (block.m_123342_() < ((BlockPos)root.get()).m_123342_()) {
                root.set((BlockPos)block);
            }
        });
        return root.get();
    }
}

