/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.spells.components;

import com.mna.api.affinity.Affinity;
import com.mna.api.sound.SFX;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.sosly.arcaneadditions.recipes.PlowTransformationRecipe;
import org.sosly.arcaneadditions.recipes.RecipeRegistry;

public class PlowComponent
extends SpellEffect {
    public PlowComponent(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair[0]);
    }

    public ComponentApplicationResult ApplyEffect(SpellSource caster, SpellTarget target, IModifiedSpellPart<SpellEffect> mods, SpellContext context) {
        if (!target.isBlock()) {
            return ComponentApplicationResult.FAIL;
        }
        Level level = context.getLevel();
        BlockPos blockPos = target.getBlock();
        BlockState state = level.m_8055_(blockPos);
        if (level.m_46859_(blockPos)) {
            return ComponentApplicationResult.FAIL;
        }
        if (!level.m_6425_(blockPos).m_76178_()) {
            return ComponentApplicationResult.FAIL;
        }
        if (state.m_60734_() instanceof EntityBlock) {
            return ComponentApplicationResult.FAIL;
        }
        if (!(level instanceof ServerLevel)) {
            return ComponentApplicationResult.SUCCESS;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        PlowTransformationRecipe recipe = this.findRecipe(serverLevel, state);
        if (recipe == null) {
            return ComponentApplicationResult.FAIL;
        }
        if (recipe.needsAir() && !level.m_46859_(blockPos.m_7494_())) {
            return ComponentApplicationResult.FAIL;
        }
        level.m_7731_(blockPos, recipe.getOutput(), 11);
        for (ItemStack drop : recipe.getDrops()) {
            Block.m_49840_((Level)level, (BlockPos)blockPos, (ItemStack)drop.m_41777_());
        }
        return ComponentApplicationResult.SUCCESS;
    }

    private PlowTransformationRecipe findRecipe(ServerLevel level, BlockState state) {
        RecipeManager recipeManager = level.m_7465_();
        List recipes = recipeManager.m_44013_((RecipeType)RecipeRegistry.PLOW_TRANSFORMATION_TYPE.get());
        for (PlowTransformationRecipe recipe : recipes) {
            if (!recipe.matches(state)) continue;
            return recipe;
        }
        return null;
    }

    public Affinity getAffinity() {
        return Affinity.WATER;
    }

    public SpellPartTags getUseTag() {
        return SpellPartTags.UTILITY;
    }

    public float initialComplexity() {
        return 5.0f;
    }

    public int requiredXPForRote() {
        return 100;
    }

    public SoundEvent SoundEffect() {
        return SFX.Spell.Cast.WATER;
    }
}

