/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.spells.components;

import com.mna.api.affinity.Affinity;
import com.mna.api.sound.SFX;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import org.sosly.arcaneadditions.effects.EffectRegistry;
import org.sosly.arcaneadditions.entities.EntityRegistry;
import org.sosly.arcaneadditions.entities.sorcery.IceBlockEntity;

public class IceBlockComponent
extends SpellEffect {
    public static String ICEBLOCK_ENTITY_ID = "arcaneadditions:ice_block_entity";

    public IceBlockComponent(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair[]{new AttributeValuePair(Attribute.DURATION, 10.0f, 2.0f, 30.0f, 2.0f, 2.0f)});
    }

    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<SpellEffect> mods, SpellContext context) {
        if (target.isLivingEntity() && Objects.requireNonNull(target.getLivingEntity()).m_21124_((MobEffect)EffectRegistry.ICE_BLOCK_EXHAUSTION.get()) == null && target.getLivingEntity().m_21124_((MobEffect)EffectRegistry.ICE_BLOCK.get()) == null) {
            target.getLivingEntity().m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.ICE_BLOCK.get(), (int)mods.getValue(Attribute.DURATION) * 20, 0));
            LivingEntity caster = source.getCaster();
            if (caster == null) {
                return ComponentApplicationResult.FAIL;
            }
            ServerLevel serverLevel = caster.m_20194_().m_129783_();
            IceBlockEntity iceBlock = (IceBlockEntity)((EntityType)EntityRegistry.ICE_BLOCK.get()).m_262496_(serverLevel, caster.m_20183_(), MobSpawnType.EVENT);
            if (iceBlock != null && caster != null) {
                if (target.isEntity() && target.getEntity() != null) {
                    Entity targetEntity = target.getEntity();
                    iceBlock.m_146926_(targetEntity.m_146909_());
                    iceBlock.m_146922_(targetEntity.m_146908_());
                    iceBlock.getPersistentData().m_128405_(ICEBLOCK_ENTITY_ID, targetEntity.m_19879_());
                    targetEntity.getPersistentData().m_128405_(ICEBLOCK_ENTITY_ID, iceBlock.m_19879_());
                }
                iceBlock.m_20242_(true);
                iceBlock.m_20331_(true);
                serverLevel.m_7967_((Entity)iceBlock);
            }
            return ComponentApplicationResult.SUCCESS;
        }
        return ComponentApplicationResult.FAIL;
    }

    public boolean canBeChanneled() {
        return false;
    }

    public Affinity getAffinity() {
        return Affinity.ICE;
    }

    public SpellPartTags getUseTag() {
        return SpellPartTags.UTILITY;
    }

    public float initialComplexity() {
        return 20.0f;
    }

    public int requiredXPForRote() {
        return 100;
    }

    public SoundEvent SoundEffect() {
        return SFX.Spell.Buff.ICE;
    }
}

