/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.networking.messages.serverbound;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.sosly.arcaneadditions.ArcaneAdditions;
import org.sosly.arcaneadditions.capabilities.treestride.TreestrideProvider;
import org.sosly.arcaneadditions.networking.BaseMessage;
import org.sosly.arcaneadditions.networking.messages.ServerMessageHandler;

public class NewTreeStrideDestination
extends BaseMessage {
    private final Component name;

    public NewTreeStrideDestination(Component name) {
        this.name = name;
    }

    public static NewTreeStrideDestination decode(FriendlyByteBuf buf) {
        NewTreeStrideDestination msg;
        try {
            Component name = buf.m_130238_();
            msg = new NewTreeStrideDestination(name);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException err) {
            ArcaneAdditions.LOGGER.error("Exception while reading SendNewTreeStrideDestinationToServer: {}", (Object)err.toString());
            return null;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(NewTreeStrideDestination msg, FriendlyByteBuf buf) {
        buf.m_130083_(msg.name);
    }

    public static void handleNewTreeStrideDestination(NewTreeStrideDestination msg, Supplier<NetworkEvent.Context> contextSupplier) {
        ServerPlayer player;
        NetworkEvent.Context ctx = contextSupplier.get();
        if (ServerMessageHandler.validateBasics(msg, ctx) && (player = ctx.getSender()) != null) {
            Level level = player.m_9236_();
            ctx.enqueueWork(() -> level.getCapability(TreestrideProvider.TREESTRIDE).ifPresent(treestride -> {
                BlockPos pos = treestride.getCurrentPosition(player);
                if (pos != null) {
                    treestride.addDestination((Player)player, msg.name.getString(), pos);
                    treestride.clearCurrentPosition(player);
                }
            }));
        }
    }
}

