/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.networking.messages.clientbound;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.sosly.arcaneadditions.ArcaneAdditions;
import org.sosly.arcaneadditions.capabilities.treestride.ITreestrideCapability;
import org.sosly.arcaneadditions.capabilities.treestride.TreestrideProvider;
import org.sosly.arcaneadditions.networking.BaseMessage;
import org.sosly.arcaneadditions.networking.messages.ClientMessageHandler;

public class SyncTreeStrideCapabilitiesToClient
extends BaseMessage {
    private final ITreestrideCapability cap;

    public SyncTreeStrideCapabilitiesToClient(ITreestrideCapability cap) {
        this.cap = cap;
    }

    public static SyncTreeStrideCapabilitiesToClient decode(FriendlyByteBuf buf) {
        SyncTreeStrideCapabilitiesToClient msg;
        try {
            CompoundTag nbt = buf.m_130260_();
            TreestrideProvider provider = new TreestrideProvider();
            provider.deserializeNBT((Tag)nbt);
            msg = new SyncTreeStrideCapabilitiesToClient((ITreestrideCapability)provider.getCapability(TreestrideProvider.TREESTRIDE).orElse(null));
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException err) {
            ArcaneAdditions.LOGGER.error("Exception while reading SyncPolymorphCapabilitiesToClient: {}", (Object)err.toString());
            return null;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(SyncTreeStrideCapabilitiesToClient msg, FriendlyByteBuf buf) {
        CompoundTag nbt = (CompoundTag)TreestrideProvider.serializeNBT(msg.cap);
        buf.m_130079_(nbt);
    }

    public static void handleTreeStrideCapabilitiesSync(SyncTreeStrideCapabilitiesToClient msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        if (ClientMessageHandler.validateBasics(msg, ctx)) {
            LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
            Optional level = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            if (level.isEmpty()) {
                ArcaneAdditions.LOGGER.error("SyncPolymorphCapabilitiesToClient context could not provide a ClientWorld");
            } else {
                ((Level)level.get()).getCapability(TreestrideProvider.TREESTRIDE).ifPresent(treestride -> {
                    treestride.reset();
                    msg.cap.getAllDestinations().forEach((uuid, destinations) -> destinations.forEach((pos, name) -> treestride.addDestination((UUID)uuid, (String)name, (BlockPos)pos)));
                });
            }
        }
    }
}

