/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.networking.messages.clientbound;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.sosly.arcaneadditions.ArcaneAdditions;
import org.sosly.arcaneadditions.capabilities.polymorph.IPolymorphCapability;
import org.sosly.arcaneadditions.capabilities.polymorph.PolymorphCapability;
import org.sosly.arcaneadditions.capabilities.polymorph.PolymorphProvider;
import org.sosly.arcaneadditions.networking.BaseMessage;
import org.sosly.arcaneadditions.networking.messages.ClientMessageHandler;

public class SyncPolymorphCapabilitiesToClient
extends BaseMessage {
    private final IPolymorphCapability cap;

    public SyncPolymorphCapabilitiesToClient() {
        this.cap = new PolymorphCapability();
    }

    public SyncPolymorphCapabilitiesToClient(IPolymorphCapability cap) {
        this.cap = cap;
    }

    public static SyncPolymorphCapabilitiesToClient decode(FriendlyByteBuf buf) {
        SyncPolymorphCapabilitiesToClient msg = new SyncPolymorphCapabilitiesToClient();
        try {
            msg.cap.setCasterUUID(buf.m_130259_());
            msg.cap.setComplexity(buf.readFloat());
            msg.cap.setHealth(buf.readFloat());
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException err) {
            ArcaneAdditions.LOGGER.error("Exception while reading SyncPolymorphCapabilitiesToClient: {}", (Object)err.toString());
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(SyncPolymorphCapabilitiesToClient msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.cap.getCasterUUID());
        buf.writeFloat(msg.cap.getComplexity());
        buf.writeFloat(msg.cap.getHealth());
    }

    public static void handlePolymorphCapabilitiesSync(SyncPolymorphCapabilitiesToClient msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        if (ClientMessageHandler.validateBasics(msg, ctx)) {
            LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
            Optional level = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            if (level.isEmpty()) {
                ArcaneAdditions.LOGGER.error("SyncPolymorphCapabilitiesToClient context could not provide a ClientWorld");
            } else {
                ctx.enqueueWork(() -> {
                    Player player = ArcaneAdditions.instance.proxy.getClientPlayer();
                    if (player != null) {
                        player.getCapability(PolymorphProvider.POLYMORPH).ifPresent(polymorph -> {
                            polymorph.setCasterUUID(msg.cap.getCasterUUID());
                            polymorph.setComplexity(msg.cap.getComplexity());
                            polymorph.setHealth(msg.cap.getHealth());
                        });
                    }
                });
            }
        }
    }
}

