/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.models;

import com.mna.blocks.tileentities.models.WizardLabModel;
import com.mna.blocks.tileentities.wizard_lab.WizardLabTile;
import com.mna.items.sorcery.ItemSpell;
import com.mna.tools.render.ModelUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.sosly.arcaneadditions.blocks.tileentities.ScribesBenchTile;

public class ScribesBenchModel
extends WizardLabModel<ScribesBenchTile> {
    private static final ResourceLocation animFile = new ResourceLocation("mna", "animations/block/none.animation.json");
    private static final ResourceLocation texFile = new ResourceLocation("mna", "textures/block/material/mandala_circle.png");
    private static final ResourceLocation modelFile = new ResourceLocation("arcaneadditions", "geo/block/scribes_desk.geo.json");
    public static final ResourceLocation ink = new ResourceLocation("mna", "block/wizard_lab/special/transcription_table_ink");
    public static final ResourceLocation lapis = new ResourceLocation("mna", "block/wizard_lab/special/transcription_table_lapis");
    public static final ResourceLocation source = new ResourceLocation("arcaneadditions", "block/scribes_bench_source");
    public static final ResourceLocation target = new ResourceLocation("arcaneadditions", "block/scribes_bench_target");

    public ScribesBenchModel() {
        this.boneOverrides.add(new WizardLabModel.GeoBoneRenderer(0, "STATICS", ink));
        this.boneOverrides.add(new WizardLabModel.GeoBoneRenderer(1, "STATICS", lapis));
        this.boneOverrides.add(new WizardLabModel.GeoBoneRenderer(2, "SPELL_SOURCE", source, pose -> pose.m_85837_(0.0, -0.06, -0.4)));
        this.boneOverrides.add(new WizardLabModel.GeoBoneRenderer(3, "SPELL_TARGET", target, pose -> pose.m_85837_(0.0, -0.06, -0.4)));
        this.boneOverrides.add(new WizardLabModel.GeoBoneRenderer(3, "SPELL_TARGET_WRITTEN", source, pose -> pose.m_85837_(-0.375, -0.06, -0.4)));
    }

    public void renderBoneAdditions(WizardLabTile tile, String bone, PoseStack stack, MultiBufferSource bufferIn, RenderType renderType, int packedLightIn, int packedOverlayIn) {
        Minecraft mc = Minecraft.m_91087_();
        ItemRenderer itemRenderer = mc.m_91291_();
        this.boneOverrides.stream().filter(b -> b.bone.equals(bone) && (b.slot == -1 || tile.hasStack(b.slot))).filter(b -> {
            if (b.slot != 3) {
                return true;
            }
            return b.model.equals((Object)target) != tile.m_8020_(b.slot).m_41720_() instanceof ItemSpell;
        }).forEach(b -> {
            if (b.poseAdjuster != null) {
                stack.m_85836_();
                b.poseAdjuster.accept(stack);
            }
            if (b.model != null) {
                ModelUtils.renderModel((VertexConsumer)bufferIn.m_6299_(RenderType.m_110451_()), (Level)tile.m_58904_(), (BlockPos)tile.m_58899_(), (BlockState)tile.m_58900_(), (ResourceLocation)b.model, (PoseStack)stack, (int)packedLightIn, (int)packedOverlayIn);
            } else {
                ItemStack stackToRender = !b.stack.m_41619_() ? b.stack : tile.m_8020_(b.slot);
                itemRenderer.m_269128_(stackToRender, ItemDisplayContext.GROUND, packedLightIn, packedOverlayIn, stack, bufferIn, (Level)mc.f_91073_, 0);
            }
            if (b.poseAdjuster != null) {
                stack.m_85849_();
            }
        });
    }

    public ResourceLocation getAnimationResource(ScribesBenchTile arg0) {
        return animFile;
    }

    public ResourceLocation getModelResource(ScribesBenchTile arg0) {
        return modelFile;
    }

    public ResourceLocation getTextureResource(ScribesBenchTile arg0) {
        return texFile;
    }
}

