/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.items.artifice;

import com.mna.api.ManaAndArtificeMod;
import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.entities.construct.IConstruct;
import com.mna.api.items.IPhylacteryItem;
import com.mna.api.items.TieredItem;
import com.mna.api.sound.SFX;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.sosly.arcaneadditions.config.ServerConfig;
import org.sosly.arcaneadditions.entities.EntityRegistry;
import org.sosly.arcaneadditions.entities.sorcery.SoulSearchersBeamEntity;
import org.sosly.arcaneadditions.sounds.UseItemTickingSoundInstance;

public class SoulsearchersLensItem
extends TieredItem {
    private static final String TARGET_KEY = "soulsearcher-target";

    public SoulsearchersLensItem() {
        super(new Item.Properties().m_41487_(1));
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack item) {
        return UseAnim.SPYGLASS;
    }

    public int m_8105_(@NotNull ItemStack item) {
        return 999999;
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack item, Player player, @NotNull LivingEntity target, @NotNull InteractionHand hand) {
        if (!(target instanceof Mob) || target instanceof IConstruct) {
            return InteractionResult.FAIL;
        }
        player.getPersistentData().m_128405_(TARGET_KEY, target.m_19879_());
        return InteractionResult.SUCCESS;
    }

    public void m_5929_(Level level, LivingEntity user, ItemStack lens, int ticks) {
        ItemStack phylactery;
        Optional magicCapability;
        if (ticks % 20 != 0 || !(user instanceof Player)) {
            return;
        }
        Player player = (Player)user;
        int beamID = lens.m_41784_().m_128451_("beam");
        SoulSearchersBeamEntity beam = (SoulSearchersBeamEntity)level.m_6815_(beamID);
        if (beam != null) {
            beam.m_146884_(user.m_146892_());
        }
        if ((magicCapability = player.getCapability(ManaAndArtificeMod.getMagicCapability()).resolve()).isEmpty()) {
            player.m_21253_();
            return;
        }
        IPlayerMagic magic = (IPlayerMagic)magicCapability.get();
        if (!magic.isMagicUnlocked()) {
            player.m_21253_();
            return;
        }
        int targetId = player.getPersistentData().m_128451_(TARGET_KEY);
        Mob target = (Mob)level.m_6815_(targetId);
        InteractionHand hand = player.m_7655_();
        ItemStack itemStack = phylactery = hand == InteractionHand.MAIN_HAND ? user.m_21206_() : user.m_21205_();
        if (target == null || phylactery.m_41613_() == 0) {
            player.m_21253_();
            return;
        }
        if (!this.useOn(level, player, target, phylactery)) {
            player.m_21253_();
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack lens = hand == InteractionHand.MAIN_HAND ? player.m_21205_() : player.m_21206_();
        ItemStack phylacteryStack = hand == InteractionHand.MAIN_HAND ? player.m_21206_() : player.m_21205_();
        int targetID = player.getPersistentData().m_128451_(TARGET_KEY);
        Mob target = (Mob)level.m_6815_(targetID);
        if (target == null) {
            return InteractionResultHolder.m_19100_((Object)lens);
        }
        Optional magicCapability = player.getCapability(ManaAndArtificeMod.getMagicCapability()).resolve();
        if (magicCapability.isEmpty()) {
            return InteractionResultHolder.m_19100_((Object)lens);
        }
        IPlayerMagic magic = (IPlayerMagic)magicCapability.get();
        if (!magic.isMagicUnlocked()) {
            if (level.m_5776_()) {
                player.m_213846_((Component)Component.m_237115_((String)"item.arcaneadditions.soulsearchers_lens.confusion"));
            }
            return InteractionResultHolder.m_19100_((Object)lens);
        }
        Item item = phylacteryStack.m_41720_();
        if (!(item instanceof IPhylacteryItem)) {
            return InteractionResultHolder.m_19100_((Object)lens);
        }
        IPhylacteryItem phylactery = (IPhylacteryItem)item;
        if (phylactery.isFull(phylacteryStack)) {
            if (level.m_5776_()) {
                player.m_213846_((Component)Component.m_237115_((String)"item.arcaneadditions.soulsearchers_lens.nonphylactery"));
            }
            return InteractionResultHolder.m_19100_((Object)lens);
        }
        if (level.m_5776_()) {
            this.PlayLoopingSound(SFX.Loops.ARCANE, player);
        } else {
            SoulSearchersBeamEntity beam = new SoulSearchersBeamEntity((EntityType<? extends SoulSearchersBeamEntity>)((EntityType)EntityRegistry.SOUL_SEARCHERS_BEAM.get()), player.m_9236_());
            beam.setSource((LivingEntity)player);
            beam.setTarget((LivingEntity)target);
            beam.m_146884_(player.m_146892_());
            lens.m_41784_().m_128405_("beam", beam.m_19879_());
            level.m_7967_((Entity)beam);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19098_((Object)lens);
    }

    public boolean canContinueUsing(@NotNull ItemStack oldStack, ItemStack newStack) {
        return true;
    }

    public void m_5551_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity user, int ticks) {
        if (user instanceof Player) {
            user.getPersistentData().m_128473_(TARGET_KEY);
            ((Player)user).m_36335_().m_41524_((Item)this, 40);
            ItemStack lens = user.m_7655_() == InteractionHand.MAIN_HAND ? user.m_21205_() : user.m_21206_();
            int beamID = lens.m_41784_().m_128451_("beam");
            SoulSearchersBeamEntity beam = (SoulSearchersBeamEntity)level.m_6815_(beamID);
            if (beam != null) {
                beam.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    private boolean useOn(@NotNull Level level, @NotNull Player player, @NotNull Mob target, ItemStack phylactery) {
        float amount;
        float adjustedHealth = target.m_21233_() * this.getAdjustmentForType(target.m_6095_());
        int levelsRequired = (int)Math.max(1.0, Math.floor(adjustedHealth / (float)ServerConfig.soulSearchersLensHealthPerLevel));
        if (target.m_20270_((Entity)player) > (float)ServerConfig.soulSearchersLensMaxDistance) {
            if (level.f_46443_) {
                player.m_213846_((Component)Component.m_237115_((String)"item.arcaneadditions.soulsearchers_lens.distance"));
            }
            return false;
        }
        if (player.f_36078_ < levelsRequired && !player.m_7500_()) {
            if (level.f_46443_) {
                player.m_213846_((Component)Component.m_237115_((String)"item.arcaneadditions.soulsearchers_lens.experience"));
            }
            return false;
        }
        EntityType type = target.m_6095_();
        boolean added = this.addToPhylactery(player, phylactery, (EntityType<? extends Mob>)type, amount = player.m_7500_() ? (float)((IPhylacteryItem)phylactery.m_41720_()).getMaximumFill() : 1.0f, target.m_9236_());
        if (added) {
            player.m_6749_(-levelsRequired);
        }
        return added;
    }

    private float getAdjustmentForType(EntityType entityType) {
        String type = entityType.m_20675_();
        for (String mod : ServerConfig.soulSearchersLensCreatureModifiers) {
            String[] parts = mod.split(",");
            if (parts.length != 2) continue;
            String registryName = parts[0];
            String stringModifier = parts[1];
            if (!type.equals(registryName)) continue;
            return Float.parseFloat(stringModifier);
        }
        return 1.0f;
    }

    private boolean addToPhylactery(Player player, @NotNull ItemStack phylactery, EntityType<? extends Mob> type, float amount, Level level) {
        float current = ((IPhylacteryItem)phylactery.m_41720_()).getContainedSouls(phylactery);
        return ((IPhylacteryItem)phylactery.m_41720_()).fill(phylactery, type, current + amount, level);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void PlayLoopingSound(SoundEvent soundID, Player player) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new UseItemTickingSoundInstance(soundID, player));
    }
}

