/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.gui.screens;

import com.mojang.blaze3d.platform.InputConstants;
import java.awt.Color;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import org.sosly.arcaneadditions.capabilities.treestride.TreestrideProvider;
import org.sosly.arcaneadditions.gui.menus.TreeStrideMenu;
import org.sosly.arcaneadditions.gui.widgets.TreeStrideDelete;
import org.sosly.arcaneadditions.gui.widgets.TreeStrideDestination;
import org.sosly.arcaneadditions.networking.PacketHandler;
import org.sosly.arcaneadditions.networking.messages.serverbound.NewTreeStrideDestination;
import org.sosly.arcaneadditions.networking.messages.serverbound.RemoveTreeStrideDestination;
import org.sosly.arcaneadditions.networking.messages.serverbound.RequestSyncTreeStrideCapabilitiesFromServer;
import org.sosly.arcaneadditions.networking.messages.serverbound.TreeStridePlayer;
import org.sosly.arcaneadditions.utils.RLoc;

public class TreeStrideScreen
extends AbstractContainerScreen<TreeStrideMenu> {
    private Player player;
    private static final ResourceLocation TEXTURE = RLoc.create("textures/gui/tree_stride.png");
    private ExtendedButton createDestinationButton;
    private EditBox createDestinationBox;

    public TreeStrideScreen(TreeStrideMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.player = inventory.f_35978_;
        this.f_97735_ = 0;
        this.f_97736_ = 0;
        this.f_97726_ = 176;
        this.f_97727_ = 150;
        this.f_97728_ = 8;
        this.f_97729_ = 5;
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Minecraft.m_91087_().f_91073_.getCapability(TreestrideProvider.TREESTRIDE).ifPresent(treestride -> {
            Map<BlockPos, String> destinations = treestride.getPlayerDestinations((Player)Minecraft.m_91087_().f_91074_);
            if (destinations != null) {
                AtomicInteger topPos = new AtomicInteger(2);
                destinations.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(destination -> {
                    topPos.addAndGet(12);
                    this.m_142416_((GuiEventListener)new TreeStrideDelete(this.f_97735_ + 10, this.f_97736_ + topPos.get(), 14, 14, (Component)Component.m_237113_((String)"X"), btn -> this.deleteDestination((BlockPos)destination.getKey(), (String)destination.getValue())));
                    this.m_142416_((GuiEventListener)new TreeStrideDestination(this.f_97735_ + 24, this.f_97736_ + topPos.get(), 130, 14, (Component)Component.m_237113_((String)((String)destination.getValue())), btn -> this.teleportPlayer((BlockPos)destination.getKey(), (String)destination.getValue())));
                });
                if (destinations.size() >= 7) {
                    this.createDestinationBox.f_93624_ = false;
                    this.createDestinationButton.f_93624_ = false;
                }
            }
        });
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        pGuiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, Color.lightGray.getRGB(), true);
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float partialTicks, int mouse_x, int mouse_y) {
        this.m_280273_(pGuiGraphics);
        int xPos = this.f_97735_;
        int yPos = this.f_97736_;
        pGuiGraphics.m_280163_(TEXTURE, xPos, yPos, 0.0f, 0.0f, this.f_97726_, this.f_97727_, this.f_97726_, this.f_97727_);
    }

    public void m_7856_() {
        PacketHandler.network.sendToServer((Object)new RequestSyncTreeStrideCapabilitiesFromServer());
        super.m_7856_();
        EditBox newDestination = new EditBox(this.f_96547_, this.f_97735_ + 8, this.f_97736_ + 128, 117, 12, this.createDestinationBox, (Component)Component.m_237115_((String)"arcaneadditions:components/tree_stride.new_destination"));
        newDestination.m_94199_(24);
        this.createDestinationBox = (EditBox)this.m_142416_((GuiEventListener)newDestination);
        this.createDestinationButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.f_97735_ + 128, this.f_97736_ + 126, 40, 16, (Component)Component.m_237115_((String)"arcaneadditions:components/tree_stride.save"), btn -> this.handleNewDestination()));
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)pKeyCode, (int)pScanCode);
        if (mouseKey.m_84873_() == 256) {
            this.m_7379_();
            return true;
        }
        if (this.createDestinationBox.m_94204_()) {
            if (mouseKey.m_84873_() == 257) {
                return this.handleNewDestination();
            }
            return this.createDestinationBox.m_7933_(pKeyCode, pScanCode, pModifiers);
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    private void deleteDestination(BlockPos pos, String name) {
        PacketHandler.network.sendToServer((Object)new RemoveTreeStrideDestination(pos));
        this.m_7379_();
        Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237110_((String)"arcaneadditions:components/tree_stride.removed_destination", (Object[])new Object[]{name}));
    }

    private boolean handleNewDestination() {
        String newValue = this.createDestinationBox.m_94155_();
        if (newValue.length() == 0) {
            return false;
        }
        PacketHandler.network.sendToServer((Object)new NewTreeStrideDestination((Component)Component.m_237113_((String)newValue)));
        this.m_7379_();
        Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237110_((String)"arcaneadditions:components/tree_stride.added_destination", (Object[])new Object[]{newValue}));
        return true;
    }

    private void teleportPlayer(BlockPos pos, String name) {
        this.m_7379_();
        PacketHandler.network.sendToServer((Object)new TreeStridePlayer(pos));
        Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237110_((String)"arcaneadditions:components/tree_stride.travel", (Object[])new Object[]{name}));
    }
}

