/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.gui.menus;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import org.sosly.arcaneadditions.capabilities.familiar.IFamiliarCapability;
import org.sosly.arcaneadditions.gui.MenuRegistry;
import org.sosly.arcaneadditions.spells.FamiliarSpell;
import org.sosly.arcaneadditions.utils.FamiliarHelper;

public class FamiliarMenu
extends AbstractContainerMenu {
    private final IFamiliarCapability capability;
    private final Mob familiar;
    private UUID familiarUuid;
    private String familiarName;
    private String familiarType;
    private String familiarRegistryName;
    private float familiarHealth;
    private float familiarMaxHealth;
    private float mana;
    private float maxMana;
    private CompoundTag familiarNbt;
    private List<SpellData> spells = new ArrayList<SpellData>();

    public FamiliarMenu(int id, Inventory playerInv) {
        this(id, playerInv, FamiliarHelper.getFamiliarCapability(playerInv.f_35978_));
    }

    public FamiliarMenu(int id, Inventory playerInv, FriendlyByteBuf extraData) {
        this(id, playerInv, (IFamiliarCapability)null);
        this.familiarUuid = extraData.m_130259_();
        this.familiarName = extraData.m_130277_();
        this.familiarType = extraData.m_130277_();
        this.familiarRegistryName = extraData.m_130277_();
        this.familiarHealth = extraData.readFloat();
        this.familiarMaxHealth = extraData.readFloat();
        this.mana = extraData.readFloat();
        this.maxMana = extraData.readFloat();
        this.familiarNbt = extraData.m_130260_();
        int spellCount = extraData.readInt();
        for (int i = 0; i < spellCount; ++i) {
            Component name = extraData.m_130238_();
            float manaCost = extraData.readFloat();
            FamiliarSpell.Frequency frequency = (FamiliarSpell.Frequency)extraData.m_130066_(FamiliarSpell.Frequency.class);
            boolean offensive = extraData.readBoolean();
            this.spells.add(new SpellData(name, manaCost, frequency, offensive));
        }
    }

    public FamiliarMenu(int id, Inventory playerInv, IFamiliarCapability capability) {
        super((MenuType)MenuRegistry.FAMILIAR.get(), id);
        this.capability = capability;
        this.familiar = capability != null ? capability.getFamiliar() : null;
    }

    public ItemStack m_7648_(Player player, int pIndex) {
        return null;
    }

    public boolean m_6875_(Player player) {
        if (player.m_9236_().m_5776_()) {
            return true;
        }
        if (this.capability == null || this.familiar == null) {
            return false;
        }
        if (!this.capability.getCaster().equals((Object)player)) {
            return false;
        }
        return this.familiar.m_6084_() && player.m_20280_((Entity)this.familiar) < 64.0;
    }

    public IFamiliarCapability getCapability() {
        return this.capability;
    }

    public Mob getFamiliar() {
        return this.familiar;
    }

    public boolean hasClientData() {
        return this.familiarUuid != null;
    }

    public String getFamiliarName() {
        return this.familiarName;
    }

    public String getFamiliarType() {
        return this.familiarType;
    }

    public String getFamiliarRegistryName() {
        return this.familiarRegistryName;
    }

    public float getFamiliarHealth() {
        return this.familiarHealth;
    }

    public float getFamiliarMaxHealth() {
        return this.familiarMaxHealth;
    }

    public float getMana() {
        return this.mana;
    }

    public float getMaxMana() {
        return this.maxMana;
    }

    public List<SpellData> getSpellData() {
        return this.spells;
    }

    public CompoundTag getFamiliarNbt() {
        return this.familiarNbt;
    }

    public void updateFromServerData() {
        if (this.capability != null && this.familiar != null) {
            this.familiarHealth = this.familiar.m_21223_();
            this.familiarMaxHealth = this.familiar.m_21233_();
            this.mana = this.capability.getCastingResource().getAmount();
            this.maxMana = this.capability.getCastingResource().getMaxAmount();
        }
    }

    public void updateClientData(float health, float maxHealth, float mana, float maxMana) {
        this.familiarHealth = health;
        this.familiarMaxHealth = maxHealth;
        this.mana = mana;
        this.maxMana = maxMana;
    }

    public static class SpellData {
        public final Component name;
        public final float manaCost;
        public final FamiliarSpell.Frequency frequency;
        public final boolean offensive;

        public SpellData(Component name, float manaCost, FamiliarSpell.Frequency frequency, boolean offensive) {
            this.name = name;
            this.manaCost = manaCost;
            this.frequency = frequency;
            this.offensive = offensive;
        }
    }
}

