/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.events.spells;

import com.mna.api.ManaAndArtificeMod;
import com.mna.api.spells.ICanContainSpell;
import com.mna.api.spells.base.ISpellDefinition;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.sosly.arcaneadditions.api.spells.components.IPolymorphProvider;
import org.sosly.arcaneadditions.capabilities.polymorph.IPolymorphCapability;
import org.sosly.arcaneadditions.capabilities.polymorph.PolymorphProvider;
import org.sosly.arcaneadditions.compats.CompatRegistry;
import org.sosly.arcaneadditions.config.ServerConfig;
import org.sosly.arcaneadditions.effects.EffectRegistry;
import org.sosly.arcaneadditions.effects.beneficial.PolymorphEffect;
import org.sosly.arcaneadditions.spells.components.PolymorphComponent;

@Mod.EventBusSubscriber(modid="arcaneadditions", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PolymorphEvents {
    @SubscribeEvent
    public static void onAttachCapability(AttachCapabilitiesEvent<?> event) {
        if (event.getObject() instanceof Player && ModList.get().isLoaded("walkers")) {
            event.addCapability(IPolymorphCapability.POLYMORPH_CAPABILITY, (ICapabilityProvider)new PolymorphProvider());
        }
    }

    @SubscribeEvent
    public static void onBlockInteract(PlayerInteractEvent.RightClickBlock event) {
        PolymorphEvents.handleRestrictedActions((LivingEvent)event);
    }

    @SubscribeEvent
    public static void onBreakingBlock(PlayerEvent.BreakSpeed event) {
        PolymorphEvents.handleRestrictedActions((LivingEvent)event);
    }

    @SubscribeEvent
    public static void onDamage(LivingDamageEvent event) {
        PolymorphEvents.runOnEffect((Event)event, (instance, entity) -> {
            if (!(entity instanceof Player)) {
                return;
            }
            float amount = event.getAmount();
            if (entity.m_21223_() - amount <= 0.0f) {
                event.setCanceled(true);
                entity.m_21195_((MobEffect)EffectRegistry.POLYMORPH.get());
            }
        });
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        PolymorphEvents.handleRestrictedActions((LivingEvent)event);
    }

    @SubscribeEvent
    public static void onHarvest(PlayerEvent.HarvestCheck event) {
        PolymorphEvents.handleRestrictedActions((LivingEvent)event);
    }

    @SubscribeEvent
    public static void onItemInteract(PlayerInteractEvent.RightClickItem event) {
        PolymorphEvents.handleRestrictedActions((LivingEvent)event);
    }

    @SubscribeEvent
    public static void onPotionRemoved(MobEffectEvent.Remove event) {
        PolymorphEvents.runOnEffect((Event)event, (instance, entity) -> {
            if (!(entity instanceof Player)) {
                return;
            }
            if (!event.getEntity().m_9236_().m_5776_()) {
                IPolymorphProvider polymorpher = CompatRegistry.getPolymorphCompat();
                if (polymorpher == null) {
                    return;
                }
                polymorpher.unpolymorph((ServerPlayer)event.getEntity());
                PolymorphComponent.resetBonusHealth((ServerPlayer)event.getEntity());
                entity.getCapability(PolymorphProvider.POLYMORPH).ifPresent(polymorph -> {
                    entity.m_21153_(polymorph.getHealth());
                    polymorph.reset();
                });
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerAttack(AttackEntityEvent event) {
        PolymorphEvents.handleRestrictedActions((LivingEvent)event);
    }

    private static void handleRestrictedActions(LivingEvent event) {
        PolymorphEvents.runOnEffect((Event)event, (instance, entity) -> {
            if (!(entity instanceof Player)) {
                return;
            }
            Player caster = (Player)entity;
            ItemStack stack = entity.m_21205_();
            if (stack.m_41720_() instanceof AirItem || stack.m_41720_() instanceof BlockItem) {
                return;
            }
            Level level = event.getEntity().m_9236_();
            if (!level.m_5776_() && stack.m_41720_() instanceof ICanContainSpell) {
                AtomicBoolean isPolymorph = new AtomicBoolean(false);
                ISpellDefinition recipe = ManaAndArtificeMod.getSpellHelper().parseSpellDefinition(stack, caster);
                recipe.iterateComponents(component -> {
                    if (component.getPart() instanceof PolymorphComponent) {
                        isPolymorph.set(true);
                    }
                });
                if (isPolymorph.get()) {
                    return;
                }
                if (ServerConfig.polymorphAllowSpellcasting) {
                    return;
                }
            }
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
            if (event instanceof PlayerInteractEvent) {
                event.setResult(Event.Result.DENY);
            }
            if (event instanceof PlayerEvent.HarvestCheck) {
                ((PlayerEvent.HarvestCheck)event).setCanHarvest(false);
            }
        });
    }

    private static void runOnEffect(Event event, EffectRegistry.ILivingMobEffectInstanceHandler handler) {
        if (!(event instanceof LivingEvent)) {
            return;
        }
        LivingEntity entity = ((LivingEvent)event).getEntity();
        Collection effects = entity.m_21220_();
        for (MobEffectInstance instance : effects) {
            MobEffect effect = instance.m_19544_();
            if (!(effect instanceof PolymorphEffect)) continue;
            EffectRegistry.handle(handler, instance, entity);
        }
    }
}

