/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.events.spells;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.sosly.arcaneadditions.effects.EffectRegistry;
import org.sosly.arcaneadditions.effects.beneficial.LifeLinkEffect;

@Mod.EventBusSubscriber(modid="arcaneadditions", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LifeLinkEvents {
    @SubscribeEvent
    public static void onDamage(LivingDamageEvent event) {
        LifeLinkEvents.runOnEffect((Event)event, (instance, entity) -> {
            float total = event.getAmount();
            int linkedID = entity.getPersistentData().m_128451_("linked");
            Entity linked = entity.m_9236_().m_6815_(linkedID);
            if (linked instanceof LivingEntity) {
                LivingEntity livingLinked = (LivingEntity)linked;
                float targetHealth = entity.m_21223_();
                float linkedHealth = livingLinked.m_21223_();
                float goal = total / 2.0f;
                if (linkedHealth < total / 2.0f) {
                    goal = total - linkedHealth;
                } else if (targetHealth < total / 2.0f) {
                    goal = total - targetHealth;
                }
                event.setAmount(goal);
                livingLinked.m_6469_(event.getSource(), goal);
            }
        });
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        LifeLinkEvents.runOnEffect((Event)event, (instance, entity) -> {
            int linkedID = entity.getPersistentData().m_128451_("linked");
            Entity linked = entity.m_9236_().m_6815_(linkedID);
            if (linked instanceof LivingEntity) {
                LivingEntity livingLinked = (LivingEntity)linked;
                livingLinked.m_21195_((MobEffect)EffectRegistry.LIFE_LINK.get());
            }
        });
    }

    @SubscribeEvent
    public static void onChangeDimensions(PlayerEvent.PlayerChangedDimensionEvent event) {
        LifeLinkEvents.runOnEffect((Event)event, (instance, entity) -> {
            int linkedID = entity.getPersistentData().m_128451_("linked");
            Entity linked = entity.m_9236_().m_6815_(linkedID);
            if (linked instanceof LivingEntity) {
                LivingEntity livingLinked = (LivingEntity)linked;
                entity.m_21195_((MobEffect)EffectRegistry.LIFE_LINK.get());
                livingLinked.m_21195_((MobEffect)EffectRegistry.LIFE_LINK.get());
            }
        });
    }

    private static void runOnEffect(Event event, EffectRegistry.ILivingMobEffectInstanceHandler handler) {
        LivingEntity entity;
        if (event instanceof LivingEvent) {
            LivingEvent livingEvent = (LivingEvent)event;
            entity = livingEvent.getEntity();
        } else if (event instanceof RenderLivingEvent) {
            RenderLivingEvent livingEvent = (RenderLivingEvent)event;
            entity = livingEvent.getEntity();
        } else {
            return;
        }
        for (MobEffectInstance instance : entity.m_21220_()) {
            if (!(instance.m_19544_() instanceof LifeLinkEffect)) continue;
            EffectRegistry.handle(handler, instance, entity);
        }
    }
}

