/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.events.entities;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.sosly.arcaneadditions.capabilities.familiar.IFamiliarCapability;
import org.sosly.arcaneadditions.gui.menus.FamiliarMenu;
import org.sosly.arcaneadditions.spells.FamiliarSpell;
import org.sosly.arcaneadditions.utils.FamiliarHelper;
import org.sosly.arcaneadditions.utils.RLoc;

@Mod.EventBusSubscriber(modid="arcaneadditions", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FamiliarInteractionHandler {
    @SubscribeEvent
    public static void onInteract(PlayerInteractEvent.EntityInteract event) {
        final IFamiliarCapability cap = FamiliarHelper.getFamiliarCapability(event.getEntity());
        if (cap == null) {
            return;
        }
        Mob familiar = cap.getFamiliar();
        if (familiar == null || !familiar.equals((Object)event.getTarget())) {
            return;
        }
        if (!cap.getCaster().equals((Object)event.getEntity())) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        if (event.getEntity().m_6144_()) {
            if (event.getSide() != LogicalSide.SERVER) {
                event.setCanceled(true);
                return;
            }
            MenuProvider menuProvider = new MenuProvider(){

                public Component m_5446_() {
                    return Component.m_237113_((String)"Familiar");
                }

                public AbstractContainerMenu m_7208_(int id, Inventory playerInv, Player player) {
                    return new FamiliarMenu(id, playerInv, cap);
                }
            };
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)menuProvider, buf -> {
                buf.m_130077_(familiar.m_20148_());
                buf.m_130070_(cap.getName());
                buf.m_130070_(familiar.m_6095_().m_20675_());
                buf.m_130070_(ForgeRegistries.ENTITY_TYPES.getKey((Object)familiar.m_6095_()).toString());
                buf.writeFloat(familiar.m_21223_());
                buf.writeFloat(familiar.m_21233_());
                buf.writeFloat(cap.getCastingResource().getAmount());
                buf.writeFloat(cap.getCastingResource().getMaxAmount());
                buf.m_130079_(familiar.m_20240_(new CompoundTag()));
                buf.writeInt(cap.getSpellsKnown().size());
                for (FamiliarSpell spell : cap.getSpellsKnown()) {
                    buf.m_130083_(spell.getName());
                    buf.writeFloat(spell.getRecipe().getManaCost());
                    buf.m_130068_((Enum)spell.getFrequency());
                    buf.writeBoolean(spell.isOffensive());
                }
            });
            event.setCanceled(true);
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.m_204131_().anyMatch(tag -> tag.f_203868_().equals((Object)RLoc.create("can_bap_familiars")))) {
            cap.setBapped(true);
            familiar.m_142687_(Entity.RemovalReason.DISCARDED);
            event.setCanceled(true);
            return;
        }
        if (cap.getLastInteract() > event.getLevel().m_46467_() - 20L) {
            return;
        }
        cap.setOrderedToStay(!cap.isOrderedToStay());
    }

    @SubscribeEvent
    public static void onFamiliarTravelToDimension(EntityTravelToDimensionEvent event) {
        Mob mob;
        Entity entity = event.getEntity();
        if (!(entity instanceof Mob) || !FamiliarHelper.isFamiliar(mob = (Mob)entity)) {
            return;
        }
        event.setCanceled(true);
    }
}

